package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SourceBuilder extends SourceFluent<SourceBuilder> implements VisitableBuilder<Source,SourceBuilder>{
  public SourceBuilder() {
    this(new Source());
  }
  
  public SourceBuilder(SourceFluent<?> fluent) {
    this(fluent, new Source());
  }
  
  public SourceBuilder(SourceFluent<?> fluent,Source instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SourceBuilder(Source instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SourceFluent<?> fluent;
  
  public Source build() {
    Source buildable = new Source(fluent.getIpBlocks(),fluent.getNamespaces(),fluent.getNotIpBlocks(),fluent.getNotNamespaces(),fluent.getNotPrincipals(),fluent.getNotRemoteIpBlocks(),fluent.getNotRequestPrincipals(),fluent.getPrincipals(),fluent.getRemoteIpBlocks(),fluent.getRequestPrincipals());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}