package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StringMatchFluent<A extends StringMatchFluent<A>> extends BaseFluent<A>{
  public StringMatchFluent() {
  }
  
  public StringMatchFluent(StringMatch instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsStringMatchMatchType,?> matchType;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StringMatch instance) {
    instance = (instance != null ? instance : new StringMatch());
    if (instance != null) {
          this.withMatchType(instance.getMatchType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IsStringMatchMatchType buildMatchType() {
    return this.matchType != null ? this.matchType.build() : null;
  }
  
  public A withMatchType(IsStringMatchMatchType matchType) {
    if (matchType == null) {
        this.matchType = null;
        this._visitables.remove("matchType");
        return (A) this;
    } else {
        VisitableBuilder<? extends IsStringMatchMatchType,?> builder = builder(matchType);;
        this._visitables.clear();
        this._visitables.get("matchType").add(builder);
        this.matchType = builder;
        return (A) this;
    }
  }
  
  public boolean hasMatchType() {
    return this.matchType != null;
  }
  
  public StringMatchPrefixTypeNested<A> withNewStringMatchPrefixType() {
    return new StringMatchPrefixTypeNested(null);
  }
  
  public StringMatchPrefixTypeNested<A> withNewStringMatchPrefixTypeLike(StringMatchPrefix item) {
    return new StringMatchPrefixTypeNested(item);
  }
  
  public A withNewStringMatchPrefixType(String prefix) {
    return (A)withMatchType(new StringMatchPrefix(prefix));
  }
  
  public StringMatchRegexTypeNested<A> withNewStringMatchRegexType() {
    return new StringMatchRegexTypeNested(null);
  }
  
  public StringMatchRegexTypeNested<A> withNewStringMatchRegexTypeLike(StringMatchRegex item) {
    return new StringMatchRegexTypeNested(item);
  }
  
  public A withNewStringMatchRegexType(String regex) {
    return (A)withMatchType(new StringMatchRegex(regex));
  }
  
  public StringMatchExactTypeNested<A> withNewStringMatchExactType() {
    return new StringMatchExactTypeNested(null);
  }
  
  public StringMatchExactTypeNested<A> withNewStringMatchExactTypeLike(StringMatchExact item) {
    return new StringMatchExactTypeNested(item);
  }
  
  public A withNewStringMatchExactType(String exact) {
    return (A)withMatchType(new StringMatchExact(exact));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StringMatchFluent that = (StringMatchFluent) o;
    if (!java.util.Objects.equals(matchType, that.matchType)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(matchType,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchType != null) { sb.append("matchType:"); sb.append(matchType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1beta1."+"StringMatchPrefix": return (VisitableBuilder<T, ?>)new StringMatchPrefixBuilder((StringMatchPrefix) item);
    case "io.fabric8.istio.api.networking.v1beta1."+"StringMatchRegex": return (VisitableBuilder<T, ?>)new StringMatchRegexBuilder((StringMatchRegex) item);
    case "io.fabric8.istio.api.networking.v1beta1."+"StringMatchExact": return (VisitableBuilder<T, ?>)new StringMatchExactBuilder((StringMatchExact) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class StringMatchPrefixTypeNested<N> extends StringMatchPrefixFluent<StringMatchPrefixTypeNested<N>> implements Nested<N>{
    StringMatchPrefixTypeNested(StringMatchPrefix item) {
      this.builder = new StringMatchPrefixBuilder(this, item);
    }
    StringMatchPrefixBuilder builder;
    
    public N and() {
      return (N) StringMatchFluent.this.withMatchType(builder.build());
    }
    
    public N endStringMatchPrefixType() {
      return and();
    }
    
  
  }
  public class StringMatchRegexTypeNested<N> extends StringMatchRegexFluent<StringMatchRegexTypeNested<N>> implements Nested<N>{
    StringMatchRegexTypeNested(StringMatchRegex item) {
      this.builder = new StringMatchRegexBuilder(this, item);
    }
    StringMatchRegexBuilder builder;
    
    public N and() {
      return (N) StringMatchFluent.this.withMatchType(builder.build());
    }
    
    public N endStringMatchRegexType() {
      return and();
    }
    
  
  }
  public class StringMatchExactTypeNested<N> extends StringMatchExactFluent<StringMatchExactTypeNested<N>> implements Nested<N>{
    StringMatchExactTypeNested(StringMatchExact item) {
      this.builder = new StringMatchExactBuilder(this, item);
    }
    StringMatchExactBuilder builder;
    
    public N and() {
      return (N) StringMatchFluent.this.withMatchType(builder.build());
    }
    
    public N endStringMatchExactType() {
      return and();
    }
    
  
  }

}