package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServerTLSSettingsBuilder extends ServerTLSSettingsFluent<ServerTLSSettingsBuilder> implements VisitableBuilder<ServerTLSSettings,ServerTLSSettingsBuilder>{
  public ServerTLSSettingsBuilder() {
    this(new ServerTLSSettings());
  }
  
  public ServerTLSSettingsBuilder(ServerTLSSettingsFluent<?> fluent) {
    this(fluent, new ServerTLSSettings());
  }
  
  public ServerTLSSettingsBuilder(ServerTLSSettingsFluent<?> fluent,ServerTLSSettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServerTLSSettingsBuilder(ServerTLSSettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServerTLSSettingsFluent<?> fluent;
  
  public ServerTLSSettings build() {
    ServerTLSSettings buildable = new ServerTLSSettings(fluent.getCaCertificates(),fluent.getCipherSuites(),fluent.getCredentialName(),fluent.getHttpsRedirect(),fluent.getMaxProtocolVersion(),fluent.getMinProtocolVersion(),fluent.getMode(),fluent.getPrivateKey(),fluent.getServerCertificate(),fluent.getSubjectAltNames(),fluent.getVerifyCertificateHash(),fluent.getVerifyCertificateSpki());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}