package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ServerFluent<A extends ServerFluent<A>> extends BaseFluent<A>{
  public ServerFluent() {
  }
  
  public ServerFluent(Server instance) {
    this.copyInstance(instance);
  }
  private String bind;
  private String defaultEndpoint;
  private List<String> hosts = new ArrayList<String>();
  private String name;
  private PortBuilder port;
  private ServerTLSSettingsBuilder tls;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Server instance) {
    instance = (instance != null ? instance : new Server());
    if (instance != null) {
          this.withBind(instance.getBind());
          this.withDefaultEndpoint(instance.getDefaultEndpoint());
          this.withHosts(instance.getHosts());
          this.withName(instance.getName());
          this.withPort(instance.getPort());
          this.withTls(instance.getTls());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBind() {
    return this.bind;
  }
  
  public A withBind(String bind) {
    this.bind = bind;
    return (A) this;
  }
  
  public boolean hasBind() {
    return this.bind != null;
  }
  
  public String getDefaultEndpoint() {
    return this.defaultEndpoint;
  }
  
  public A withDefaultEndpoint(String defaultEndpoint) {
    this.defaultEndpoint = defaultEndpoint;
    return (A) this;
  }
  
  public boolean hasDefaultEndpoint() {
    return this.defaultEndpoint != null;
  }
  
  public A addToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  
  public A setToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.set(index, item); return (A)this;
  }
  
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  
  public A addAllToHosts(Collection<String> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  
  public A removeFromHosts(java.lang.String... items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  
  public A removeAllFromHosts(Collection<String> items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  
  public List<String> getHosts() {
    return this.hosts;
  }
  
  public String getHost(int index) {
    return this.hosts.get(index);
  }
  
  public String getFirstHost() {
    return this.hosts.get(0);
  }
  
  public String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  
  public String getMatchingHost(Predicate<String> predicate) {
      for (String item : hosts) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingHost(Predicate<String> predicate) {
      for (String item : hosts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHosts(List<String> hosts) {
    if (hosts != null) {
        this.hosts = new ArrayList();
        for (String item : hosts) {
          this.addToHosts(item);
        }
    } else {
      this.hosts = null;
    }
    return (A) this;
  }
  
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {
        this.hosts.clear();
        _visitables.remove("hosts");
    }
    if (hosts != null) {
      for (String item : hosts) {
        this.addToHosts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHosts() {
    return this.hosts != null && !this.hosts.isEmpty();
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Port buildPort() {
    return this.port != null ? this.port.build() : null;
  }
  
  public A withPort(Port port) {
    this._visitables.remove("port");
    if (port != null) {
        this.port = new PortBuilder(port);
        this._visitables.get("port").add(this.port);
    } else {
        this.port = null;
        this._visitables.get("port").remove(this.port);
    }
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public A withNewPort(String name,Integer number,String protocol,Integer targetPort) {
    return (A)withPort(new Port(name, number, protocol, targetPort));
  }
  
  public PortNested<A> withNewPort() {
    return new PortNested(null);
  }
  
  public PortNested<A> withNewPortLike(Port item) {
    return new PortNested(item);
  }
  
  public PortNested<A> editPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(null));
  }
  
  public PortNested<A> editOrNewPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(new PortBuilder().build()));
  }
  
  public PortNested<A> editOrNewPortLike(Port item) {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(item));
  }
  
  public ServerTLSSettings buildTls() {
    return this.tls != null ? this.tls.build() : null;
  }
  
  public A withTls(ServerTLSSettings tls) {
    this._visitables.remove("tls");
    if (tls != null) {
        this.tls = new ServerTLSSettingsBuilder(tls);
        this._visitables.get("tls").add(this.tls);
    } else {
        this.tls = null;
        this._visitables.get("tls").remove(this.tls);
    }
    return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(ServerTLSSettings item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new ServerTLSSettingsBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(ServerTLSSettings item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServerFluent that = (ServerFluent) o;
    if (!java.util.Objects.equals(bind, that.bind)) return false;
    if (!java.util.Objects.equals(defaultEndpoint, that.defaultEndpoint)) return false;
    if (!java.util.Objects.equals(hosts, that.hosts)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bind,  defaultEndpoint,  hosts,  name,  port,  tls,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bind != null) { sb.append("bind:"); sb.append(bind + ","); }
    if (defaultEndpoint != null) { sb.append("defaultEndpoint:"); sb.append(defaultEndpoint + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PortNested<N> extends PortFluent<PortNested<N>> implements Nested<N>{
    PortNested(Port item) {
      this.builder = new PortBuilder(this, item);
    }
    PortBuilder builder;
    
    public N and() {
      return (N) ServerFluent.this.withPort(builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends ServerTLSSettingsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(ServerTLSSettings item) {
      this.builder = new ServerTLSSettingsBuilder(this, item);
    }
    ServerTLSSettingsBuilder builder;
    
    public N and() {
      return (N) ServerFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}