package io.fabric8.istio.api.networking.v1beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PortFluent<A extends PortFluent<A>> extends BaseFluent<A>{
  public PortFluent() {
  }
  
  public PortFluent(Port instance) {
    this.copyInstance(instance);
  }
  private String name;
  private Integer number;
  private String protocol;
  private Integer targetPort;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Port instance) {
    instance = (instance != null ? instance : new Port());
    if (instance != null) {
          this.withName(instance.getName());
          this.withNumber(instance.getNumber());
          this.withProtocol(instance.getProtocol());
          this.withTargetPort(instance.getTargetPort());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Integer getNumber() {
    return this.number;
  }
  
  public A withNumber(Integer number) {
    this.number = number;
    return (A) this;
  }
  
  public boolean hasNumber() {
    return this.number != null;
  }
  
  public String getProtocol() {
    return this.protocol;
  }
  
  public A withProtocol(String protocol) {
    this.protocol = protocol;
    return (A) this;
  }
  
  public boolean hasProtocol() {
    return this.protocol != null;
  }
  
  public Integer getTargetPort() {
    return this.targetPort;
  }
  
  public A withTargetPort(Integer targetPort) {
    this.targetPort = targetPort;
    return (A) this;
  }
  
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PortFluent that = (PortFluent) o;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(number, that.number)) return false;
    if (!java.util.Objects.equals(protocol, that.protocol)) return false;
    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(name,  number,  protocol,  targetPort,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (number != null) { sb.append("number:"); sb.append(number + ","); }
    if (protocol != null) { sb.append("protocol:"); sb.append(protocol + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}