package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VirtualServiceBuilder extends VirtualServiceFluent<VirtualServiceBuilder> implements VisitableBuilder<VirtualService,VirtualServiceBuilder>{
  public VirtualServiceBuilder() {
    this(new VirtualService());
  }
  
  public VirtualServiceBuilder(VirtualServiceFluent<?> fluent) {
    this(fluent, new VirtualService());
  }
  
  public VirtualServiceBuilder(VirtualServiceFluent<?> fluent,VirtualService instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VirtualServiceBuilder(VirtualService instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VirtualServiceFluent<?> fluent;
  
  public VirtualService build() {
    VirtualService buildable = new VirtualService(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}