package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadEntryBuilder extends WorkloadEntryFluentImpl<WorkloadEntryBuilder> implements VisitableBuilder<WorkloadEntry,WorkloadEntryBuilder>{
  public WorkloadEntryBuilder() {
    this(false);
  }
  public WorkloadEntryBuilder(Boolean validationEnabled) {
    this(new WorkloadEntry(), validationEnabled);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadEntry(), validationEnabled);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,WorkloadEntry instance) {
    this(fluent, instance, false);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,WorkloadEntry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadEntryBuilder(WorkloadEntry instance) {
    this(instance,false);
  }
  public WorkloadEntryBuilder(WorkloadEntry instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  WorkloadEntryFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadEntry build() {
    WorkloadEntry buildable = new WorkloadEntry(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}