package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HeadersHeaderOperationsFluentImpl<A extends HeadersHeaderOperationsFluent<A>> extends BaseFluent<A> implements HeadersHeaderOperationsFluent<A>{
  public HeadersHeaderOperationsFluentImpl() {
  }
  public HeadersHeaderOperationsFluentImpl(HeadersHeaderOperations instance) {
    this.withAdd(instance.getAdd()); 
    this.withRemove(instance.getRemove()); 
    this.withSet(instance.getSet()); 
  }
  private Map<String,String> add;
  private List<String> remove = new ArrayList<String>();
  private Map<String,String> set;
  public A addToAdd(String key,String value) {
    if(this.add == null && key != null && value != null) { this.add = new LinkedHashMap(); }
    if(key != null && value != null) {this.add.put(key, value);} return (A)this;
  }
  public A addToAdd(Map<String,String> map) {
    if(this.add == null && map != null) { this.add = new LinkedHashMap(); }
    if(map != null) { this.add.putAll(map);} return (A)this;
  }
  public A removeFromAdd(String key) {
    if(this.add == null) { return (A) this; }
    if(key != null && this.add != null) {this.add.remove(key);} return (A)this;
  }
  public A removeFromAdd(Map<String,String> map) {
    if(this.add == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.add != null){this.add.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAdd() {
    return this.add;
  }
  public <K,V>A withAdd(Map<String,String> add) {
    if (add == null) { this.add =  null;} else {this.add = new LinkedHashMap(add);} return (A) this;
  }
  public Boolean hasAdd() {
    return this.add != null;
  }
  public A addToRemove(Integer index,String item) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    this.remove.add(index, item);
    return (A)this;
  }
  public A setToRemove(Integer index,String item) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    this.remove.set(index, item); return (A)this;
  }
  public A addToRemove(java.lang.String... items) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    for (String item : items) {this.remove.add(item);} return (A)this;
  }
  public A addAllToRemove(Collection<String> items) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    for (String item : items) {this.remove.add(item);} return (A)this;
  }
  public A removeFromRemove(java.lang.String... items) {
    for (String item : items) {if (this.remove!= null){ this.remove.remove(item);}} return (A)this;
  }
  public A removeAllFromRemove(Collection<String> items) {
    for (String item : items) {if (this.remove!= null){ this.remove.remove(item);}} return (A)this;
  }
  public List<String> getRemove() {
    return this.remove;
  }
  public String getRemove(Integer index) {
    return this.remove.get(index);
  }
  public String getFirstRemove() {
    return this.remove.get(0);
  }
  public String getLastRemove() {
    return this.remove.get(remove.size() - 1);
  }
  public String getMatchingRemove(Predicate<String> predicate) {
    for (String item: remove) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRemove(Predicate<String> predicate) {
    for (String item: remove) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRemove(List<String> remove) {
    if (remove != null) {this.remove = new ArrayList(); for (String item : remove){this.addToRemove(item);}} else { this.remove = null;} return (A) this;
  }
  public A withRemove(java.lang.String... remove) {
    if (this.remove != null) {this.remove.clear();}
    if (remove != null) {for (String item :remove){ this.addToRemove(item);}} return (A) this;
  }
  public Boolean hasRemove() {
    return remove != null && !remove.isEmpty();
  }
  public A addToSet(String key,String value) {
    if(this.set == null && key != null && value != null) { this.set = new LinkedHashMap(); }
    if(key != null && value != null) {this.set.put(key, value);} return (A)this;
  }
  public A addToSet(Map<String,String> map) {
    if(this.set == null && map != null) { this.set = new LinkedHashMap(); }
    if(map != null) { this.set.putAll(map);} return (A)this;
  }
  public A removeFromSet(String key) {
    if(this.set == null) { return (A) this; }
    if(key != null && this.set != null) {this.set.remove(key);} return (A)this;
  }
  public A removeFromSet(Map<String,String> map) {
    if(this.set == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.set != null){this.set.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSet() {
    return this.set;
  }
  public <K,V>A withSet(Map<String,String> set) {
    if (set == null) { this.set =  null;} else {this.set = new LinkedHashMap(set);} return (A) this;
  }
  public Boolean hasSet() {
    return this.set != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HeadersHeaderOperationsFluentImpl that = (HeadersHeaderOperationsFluentImpl) o;
    if (add != null ? !add.equals(that.add) :that.add != null) return false;
    if (remove != null ? !remove.equals(that.remove) :that.remove != null) return false;
    if (set != null ? !set.equals(that.set) :that.set != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(add,  remove,  set,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (add != null && !add.isEmpty()) { sb.append("add:"); sb.append(add + ","); }
    if (remove != null && !remove.isEmpty()) { sb.append("remove:"); sb.append(remove + ","); }
    if (set != null && !set.isEmpty()) { sb.append("set:"); sb.append(set); }
    sb.append("}");
    return sb.toString();
  }
  
}