package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPMatchRequestBuilder extends HTTPMatchRequestFluentImpl<HTTPMatchRequestBuilder> implements VisitableBuilder<HTTPMatchRequest,HTTPMatchRequestBuilder>{
  public HTTPMatchRequestBuilder() {
    this(false);
  }
  public HTTPMatchRequestBuilder(Boolean validationEnabled) {
    this(new HTTPMatchRequest(), validationEnabled);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPMatchRequest(), validationEnabled);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,HTTPMatchRequest instance) {
    this(fluent, instance, false);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequestFluent<?> fluent,HTTPMatchRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthority(instance.getAuthority()); 
    fluent.withGateways(instance.getGateways()); 
    fluent.withHeaders(instance.getHeaders()); 
    fluent.withIgnoreUriCase(instance.getIgnoreUriCase()); 
    fluent.withMethod(instance.getMethod()); 
    fluent.withName(instance.getName()); 
    fluent.withPort(instance.getPort()); 
    fluent.withQueryParams(instance.getQueryParams()); 
    fluent.withScheme(instance.getScheme()); 
    fluent.withSourceLabels(instance.getSourceLabels()); 
    fluent.withSourceNamespace(instance.getSourceNamespace()); 
    fluent.withUri(instance.getUri()); 
    fluent.withWithoutHeaders(instance.getWithoutHeaders()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequest instance) {
    this(instance,false);
  }
  public HTTPMatchRequestBuilder(HTTPMatchRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthority(instance.getAuthority()); 
    this.withGateways(instance.getGateways()); 
    this.withHeaders(instance.getHeaders()); 
    this.withIgnoreUriCase(instance.getIgnoreUriCase()); 
    this.withMethod(instance.getMethod()); 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withQueryParams(instance.getQueryParams()); 
    this.withScheme(instance.getScheme()); 
    this.withSourceLabels(instance.getSourceLabels()); 
    this.withSourceNamespace(instance.getSourceNamespace()); 
    this.withUri(instance.getUri()); 
    this.withWithoutHeaders(instance.getWithoutHeaders()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPMatchRequestFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPMatchRequest build() {
    HTTPMatchRequest buildable = new HTTPMatchRequest(fluent.getAuthority(),fluent.getGateways(),fluent.getHeaders(),fluent.getIgnoreUriCase(),fluent.getMethod(),fluent.getName(),fluent.getPort(),fluent.getQueryParams(),fluent.getScheme(),fluent.getSourceLabels(),fluent.getSourceNamespace(),fluent.getUri(),fluent.getWithoutHeaders());
    return buildable;
  }
  
}