package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConnectionPoolSettingsHTTPSettingsBuilder extends ConnectionPoolSettingsHTTPSettingsFluentImpl<ConnectionPoolSettingsHTTPSettingsBuilder> implements VisitableBuilder<ConnectionPoolSettingsHTTPSettings,ConnectionPoolSettingsHTTPSettingsBuilder>{
  public ConnectionPoolSettingsHTTPSettingsBuilder() {
    this(false);
  }
  public ConnectionPoolSettingsHTTPSettingsBuilder(Boolean validationEnabled) {
    this(new ConnectionPoolSettingsHTTPSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettingsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConnectionPoolSettingsHTTPSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettingsFluent<?> fluent,ConnectionPoolSettingsHTTPSettings instance) {
    this(fluent, instance, false);
  }
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettingsFluent<?> fluent,ConnectionPoolSettingsHTTPSettings instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withH2UpgradePolicy(instance.getH2UpgradePolicy()); 
    fluent.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
    fluent.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
    fluent.withIdleTimeout(instance.getIdleTimeout()); 
    fluent.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
    fluent.withMaxRetries(instance.getMaxRetries()); 
    fluent.withUseClientProtocol(instance.getUseClientProtocol()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettings instance) {
    this(instance,false);
  }
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettings instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withH2UpgradePolicy(instance.getH2UpgradePolicy()); 
    this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests()); 
    this.withHttp2MaxRequests(instance.getHttp2MaxRequests()); 
    this.withIdleTimeout(instance.getIdleTimeout()); 
    this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection()); 
    this.withMaxRetries(instance.getMaxRetries()); 
    this.withUseClientProtocol(instance.getUseClientProtocol()); 
    this.validationEnabled = validationEnabled; 
  }
  ConnectionPoolSettingsHTTPSettingsFluent<?> fluent;
  Boolean validationEnabled;
  public ConnectionPoolSettingsHTTPSettings build() {
    ConnectionPoolSettingsHTTPSettings buildable = new ConnectionPoolSettingsHTTPSettings(fluent.getH2UpgradePolicy(),fluent.getHttp1MaxPendingRequests(),fluent.getHttp2MaxRequests(),fluent.getIdleTimeout(),fluent.getMaxRequestsPerConnection(),fluent.getMaxRetries(),fluent.getUseClientProtocol());
    return buildable;
  }
  
}