package io.fabric8.istio.api.meta.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IstioStatusBuilder extends IstioStatusFluentImpl<IstioStatusBuilder> implements VisitableBuilder<IstioStatus,IstioStatusBuilder>{
  public IstioStatusBuilder() {
    this(false);
  }
  public IstioStatusBuilder(Boolean validationEnabled) {
    this(new IstioStatus(), validationEnabled);
  }
  public IstioStatusBuilder(IstioStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IstioStatusBuilder(IstioStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IstioStatus(), validationEnabled);
  }
  public IstioStatusBuilder(IstioStatusFluent<?> fluent,IstioStatus instance) {
    this(fluent, instance, false);
  }
  public IstioStatusBuilder(IstioStatusFluent<?> fluent,IstioStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withValidationMessages(instance.getValidationMessages()); 
    this.validationEnabled = validationEnabled; 
  }
  public IstioStatusBuilder(IstioStatus instance) {
    this(instance,false);
  }
  public IstioStatusBuilder(IstioStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withValidationMessages(instance.getValidationMessages()); 
    this.validationEnabled = validationEnabled; 
  }
  IstioStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IstioStatus build() {
    IstioStatus buildable = new IstioStatus(fluent.getConditions(),fluent.getObservedGeneration(),fluent.getValidationMessages());
    return buildable;
  }
  
}