
package io.fabric8.istio.api.networking.v1beta1;

import java.util.HashMap;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonPropertyOrder({
    "HashKey",
    "minimumRingSize"
})
@JsonDeserialize(using = io.fabric8.kubernetes.model.jackson.JsonUnwrappedDeserializer.class)
@ToString
@EqualsAndHashCode
@Setter
@Accessors(prefix = {
    "_",
    ""
})
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(EnvVar.class),
    @BuildableReference(ContainerPort.class),
    @BuildableReference(Volume.class),
    @BuildableReference(VolumeMount.class)
})
public class LoadBalancerSettingsConsistentHashLB implements KubernetesResource
{

    @JsonProperty("HashKey")
    @JsonUnwrapped
    private IsLoadBalancerSettingsConsistentHashLBHashKey hashKey;
    @JsonProperty("minimumRingSize")
    private Integer minimumRingSize;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public LoadBalancerSettingsConsistentHashLB() {
    }

    /**
     * 
     * @param hashKey
     * @param minimumRingSize
     */
    public LoadBalancerSettingsConsistentHashLB(IsLoadBalancerSettingsConsistentHashLBHashKey hashKey, Integer minimumRingSize) {
        super();
        this.hashKey = hashKey;
        this.minimumRingSize = minimumRingSize;
    }

    @JsonProperty("HashKey")
    public IsLoadBalancerSettingsConsistentHashLBHashKey getHashKey() {
        return hashKey;
    }

    @JsonProperty("HashKey")
    public void setHashKey(IsLoadBalancerSettingsConsistentHashLBHashKey hashKey) {
        this.hashKey = hashKey;
    }

    @JsonProperty("minimumRingSize")
    public Integer getMinimumRingSize() {
        return minimumRingSize;
    }

    @JsonProperty("minimumRingSize")
    public void setMinimumRingSize(Integer minimumRingSize) {
        this.minimumRingSize = minimumRingSize;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
