package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WorkloadGroupSpecFluent<A extends WorkloadGroupSpecFluent<A>> extends BaseFluent<A>{
  public WorkloadGroupSpecFluent() {
  }
  
  public WorkloadGroupSpecFluent(WorkloadGroupSpec instance) {
    this.copyInstance(instance);
  }
  private WorkloadGroupObjectMetaBuilder metadata;
  private ReadinessProbeBuilder probe;
  private WorkloadEntrySpecBuilder template;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WorkloadGroupSpec instance) {
    instance = (instance != null ? instance : new WorkloadGroupSpec());
    if (instance != null) {
          this.withMetadata(instance.getMetadata());
          this.withProbe(instance.getProbe());
          this.withTemplate(instance.getTemplate());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public WorkloadGroupObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(WorkloadGroupObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new WorkloadGroupObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(WorkloadGroupObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new WorkloadGroupObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(WorkloadGroupObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public ReadinessProbe buildProbe() {
    return this.probe != null ? this.probe.build() : null;
  }
  
  public A withProbe(ReadinessProbe probe) {
    this._visitables.remove("probe");
    if (probe != null) {
        this.probe = new ReadinessProbeBuilder(probe);
        this._visitables.get("probe").add(this.probe);
    } else {
        this.probe = null;
        this._visitables.get("probe").remove(this.probe);
    }
    return (A) this;
  }
  
  public boolean hasProbe() {
    return this.probe != null;
  }
  
  public ProbeNested<A> withNewProbe() {
    return new ProbeNested(null);
  }
  
  public ProbeNested<A> withNewProbeLike(ReadinessProbe item) {
    return new ProbeNested(item);
  }
  
  public ProbeNested<A> editProbe() {
    return withNewProbeLike(java.util.Optional.ofNullable(buildProbe()).orElse(null));
  }
  
  public ProbeNested<A> editOrNewProbe() {
    return withNewProbeLike(java.util.Optional.ofNullable(buildProbe()).orElse(new ReadinessProbeBuilder().build()));
  }
  
  public ProbeNested<A> editOrNewProbeLike(ReadinessProbe item) {
    return withNewProbeLike(java.util.Optional.ofNullable(buildProbe()).orElse(item));
  }
  
  public WorkloadEntrySpec buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(WorkloadEntrySpec template) {
    this._visitables.remove("template");
    if (template != null) {
        this.template = new WorkloadEntrySpecBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(WorkloadEntrySpec item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new WorkloadEntrySpecBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(WorkloadEntrySpec item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WorkloadGroupSpecFluent that = (WorkloadGroupSpecFluent) o;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(probe, that.probe)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(metadata,  probe,  template,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (probe != null) { sb.append("probe:"); sb.append(probe + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MetadataNested<N> extends WorkloadGroupObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(WorkloadGroupObjectMeta item) {
      this.builder = new WorkloadGroupObjectMetaBuilder(this, item);
    }
    WorkloadGroupObjectMetaBuilder builder;
    
    public N and() {
      return (N) WorkloadGroupSpecFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class ProbeNested<N> extends ReadinessProbeFluent<ProbeNested<N>> implements Nested<N>{
    ProbeNested(ReadinessProbe item) {
      this.builder = new ReadinessProbeBuilder(this, item);
    }
    ReadinessProbeBuilder builder;
    
    public N and() {
      return (N) WorkloadGroupSpecFluent.this.withProbe(builder.build());
    }
    
    public N endProbe() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends WorkloadEntrySpecFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(WorkloadEntrySpec item) {
      this.builder = new WorkloadEntrySpecBuilder(this, item);
    }
    WorkloadEntrySpecBuilder builder;
    
    public N and() {
      return (N) WorkloadGroupSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}