package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TCPHealthCheckConfigBuilder extends TCPHealthCheckConfigFluent<TCPHealthCheckConfigBuilder> implements VisitableBuilder<TCPHealthCheckConfig,TCPHealthCheckConfigBuilder>{
  public TCPHealthCheckConfigBuilder() {
    this(new TCPHealthCheckConfig());
  }
  
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfigFluent<?> fluent) {
    this(fluent, new TCPHealthCheckConfig());
  }
  
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfigFluent<?> fluent,TCPHealthCheckConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TCPHealthCheckConfigFluent<?> fluent;
  
  public TCPHealthCheckConfig build() {
    TCPHealthCheckConfig buildable = new TCPHealthCheckConfig(fluent.getHost(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}