package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ReadinessProbeTcpSocketFluent<A extends ReadinessProbeTcpSocketFluent<A>> extends BaseFluent<A>{
  public ReadinessProbeTcpSocketFluent() {
  }
  
  public ReadinessProbeTcpSocketFluent(ReadinessProbeTcpSocket instance) {
    this.copyInstance(instance);
  }
  private TCPHealthCheckConfigBuilder tcpSocket;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ReadinessProbeTcpSocket instance) {
    instance = (instance != null ? instance : new ReadinessProbeTcpSocket());
    if (instance != null) {
          this.withTcpSocket(instance.getTcpSocket());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public TCPHealthCheckConfig buildTcpSocket() {
    return this.tcpSocket != null ? this.tcpSocket.build() : null;
  }
  
  public A withTcpSocket(TCPHealthCheckConfig tcpSocket) {
    this._visitables.remove("tcpSocket");
    if (tcpSocket != null) {
        this.tcpSocket = new TCPHealthCheckConfigBuilder(tcpSocket);
        this._visitables.get("tcpSocket").add(this.tcpSocket);
    } else {
        this.tcpSocket = null;
        this._visitables.get("tcpSocket").remove(this.tcpSocket);
    }
    return (A) this;
  }
  
  public boolean hasTcpSocket() {
    return this.tcpSocket != null;
  }
  
  public A withNewTcpSocket(String host,Integer port) {
    return (A)withTcpSocket(new TCPHealthCheckConfig(host, port));
  }
  
  public TcpSocketNested<A> withNewTcpSocket() {
    return new TcpSocketNested(null);
  }
  
  public TcpSocketNested<A> withNewTcpSocketLike(TCPHealthCheckConfig item) {
    return new TcpSocketNested(item);
  }
  
  public TcpSocketNested<A> editTcpSocket() {
    return withNewTcpSocketLike(java.util.Optional.ofNullable(buildTcpSocket()).orElse(null));
  }
  
  public TcpSocketNested<A> editOrNewTcpSocket() {
    return withNewTcpSocketLike(java.util.Optional.ofNullable(buildTcpSocket()).orElse(new TCPHealthCheckConfigBuilder().build()));
  }
  
  public TcpSocketNested<A> editOrNewTcpSocketLike(TCPHealthCheckConfig item) {
    return withNewTcpSocketLike(java.util.Optional.ofNullable(buildTcpSocket()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReadinessProbeTcpSocketFluent that = (ReadinessProbeTcpSocketFluent) o;
    if (!java.util.Objects.equals(tcpSocket, that.tcpSocket)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(tcpSocket,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (tcpSocket != null) { sb.append("tcpSocket:"); sb.append(tcpSocket + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TcpSocketNested<N> extends TCPHealthCheckConfigFluent<TcpSocketNested<N>> implements Nested<N>{
    TcpSocketNested(TCPHealthCheckConfig item) {
      this.builder = new TCPHealthCheckConfigBuilder(this, item);
    }
    TCPHealthCheckConfigBuilder builder;
    
    public N and() {
      return (N) ReadinessProbeTcpSocketFluent.this.withTcpSocket(builder.build());
    }
    
    public N endTcpSocket() {
      return and();
    }
    
  
  }

}