package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class OutlierDetectionBuilder extends OutlierDetectionFluent<OutlierDetectionBuilder> implements VisitableBuilder<OutlierDetection,OutlierDetectionBuilder>{
  public OutlierDetectionBuilder() {
    this(new OutlierDetection());
  }
  
  public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent) {
    this(fluent, new OutlierDetection());
  }
  
  public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public OutlierDetectionBuilder(OutlierDetection instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  OutlierDetectionFluent<?> fluent;
  
  public OutlierDetection build() {
    OutlierDetection buildable = new OutlierDetection(fluent.getBaseEjectionTime(),fluent.getConsecutive5xxErrors(),fluent.getConsecutiveErrors(),fluent.getConsecutiveGatewayErrors(),fluent.getConsecutiveLocalOriginFailures(),fluent.getInterval(),fluent.getMaxEjectionPercent(),fluent.getMinHealthPercent(),fluent.getSplitExternalLocalOriginErrors());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}