package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkloadGroupSpecBuilder extends WorkloadGroupSpecFluent<WorkloadGroupSpecBuilder> implements VisitableBuilder<WorkloadGroupSpec,WorkloadGroupSpecBuilder>{
  public WorkloadGroupSpecBuilder() {
    this(new WorkloadGroupSpec());
  }
  
  public WorkloadGroupSpecBuilder(WorkloadGroupSpecFluent<?> fluent) {
    this(fluent, new WorkloadGroupSpec());
  }
  
  public WorkloadGroupSpecBuilder(WorkloadGroupSpecFluent<?> fluent,WorkloadGroupSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkloadGroupSpecBuilder(WorkloadGroupSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkloadGroupSpecFluent<?> fluent;
  
  public WorkloadGroupSpec build() {
    WorkloadGroupSpec buildable = new WorkloadGroupSpec(fluent.buildMetadata(),fluent.buildProbe(),fluent.buildTemplate());
    return buildable;
  }
  

}