package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkloadGroupBuilder extends WorkloadGroupFluent<WorkloadGroupBuilder> implements VisitableBuilder<WorkloadGroup,WorkloadGroupBuilder>{
  public WorkloadGroupBuilder() {
    this(new WorkloadGroup());
  }
  
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent) {
    this(fluent, new WorkloadGroup());
  }
  
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent,WorkloadGroup instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkloadGroupBuilder(WorkloadGroup instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkloadGroupFluent<?> fluent;
  
  public WorkloadGroup build() {
    WorkloadGroup buildable = new WorkloadGroup(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}