package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkloadEntryBuilder extends WorkloadEntryFluent<WorkloadEntryBuilder> implements VisitableBuilder<WorkloadEntry,WorkloadEntryBuilder>{
  public WorkloadEntryBuilder() {
    this(new WorkloadEntry());
  }
  
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent) {
    this(fluent, new WorkloadEntry());
  }
  
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,WorkloadEntry instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkloadEntryBuilder(WorkloadEntry instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkloadEntryFluent<?> fluent;
  
  public WorkloadEntry build() {
    WorkloadEntry buildable = new WorkloadEntry(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  

}