package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServerBuilder extends ServerFluent<ServerBuilder> implements VisitableBuilder<Server,ServerBuilder>{
  public ServerBuilder() {
    this(new Server());
  }
  
  public ServerBuilder(ServerFluent<?> fluent) {
    this(fluent, new Server());
  }
  
  public ServerBuilder(ServerFluent<?> fluent,Server instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServerBuilder(Server instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServerFluent<?> fluent;
  
  public Server build() {
    Server buildable = new Server(fluent.getBind(),fluent.getDefaultEndpoint(),fluent.getHosts(),fluent.getName(),fluent.buildPort(),fluent.buildTls());
    return buildable;
  }
  

}