package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HeadersHeaderOperationsFluent<A extends HeadersHeaderOperationsFluent<A>> extends BaseFluent<A>{
  public HeadersHeaderOperationsFluent() {
  }
  
  public HeadersHeaderOperationsFluent(HeadersHeaderOperations instance) {
    this.copyInstance(instance);
  }
  private Map<String,String> add;
  private List<String> remove = new ArrayList<String>();
  private Map<String,String> set;
  
  protected void copyInstance(HeadersHeaderOperations instance) {
    instance = (instance != null ? instance : new HeadersHeaderOperations());
  
    if (instance != null) {
        this.withAdd(instance.getAdd());
        this.withRemove(instance.getRemove());
        this.withSet(instance.getSet());
        this.withAdd(instance.getAdd());
        this.withRemove(instance.getRemove());
        this.withSet(instance.getSet());
      }
  }
  
  public A addToAdd(String key,String value) {
    if(this.add == null && key != null && value != null) { this.add = new LinkedHashMap(); }
    if(key != null && value != null) {this.add.put(key, value);} return (A)this;
  }
  
  public A addToAdd(Map<String,String> map) {
    if(this.add == null && map != null) { this.add = new LinkedHashMap(); }
    if(map != null) { this.add.putAll(map);} return (A)this;
  }
  
  public A removeFromAdd(String key) {
    if(this.add == null) { return (A) this; }
    if(key != null && this.add != null) {this.add.remove(key);} return (A)this;
  }
  
  public A removeFromAdd(Map<String,String> map) {
    if(this.add == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.add != null){this.add.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getAdd() {
    return this.add;
  }
  
  public <K,V>A withAdd(Map<String,String> add) {
    if (add == null) { this.add =  null;} else {this.add = new LinkedHashMap(add);} return (A) this;
  }
  
  public boolean hasAdd() {
    return this.add != null;
  }
  
  public A addToRemove(int index,String item) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    this.remove.add(index, item);
    return (A)this;
  }
  
  public A setToRemove(int index,String item) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    this.remove.set(index, item); return (A)this;
  }
  
  public A addToRemove(java.lang.String... items) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    for (String item : items) {this.remove.add(item);} return (A)this;
  }
  
  public A addAllToRemove(Collection<String> items) {
    if (this.remove == null) {this.remove = new ArrayList<String>();}
    for (String item : items) {this.remove.add(item);} return (A)this;
  }
  
  public A removeFromRemove(java.lang.String... items) {
    if (this.remove == null) return (A)this;
    for (String item : items) { this.remove.remove(item);} return (A)this;
  }
  
  public A removeAllFromRemove(Collection<String> items) {
    if (this.remove == null) return (A)this;
    for (String item : items) { this.remove.remove(item);} return (A)this;
  }
  
  public List<String> getRemove() {
    return this.remove;
  }
  
  public String getRemove(int index) {
    return this.remove.get(index);
  }
  
  public String getFirstRemove() {
    return this.remove.get(0);
  }
  
  public String getLastRemove() {
    return this.remove.get(remove.size() - 1);
  }
  
  public String getMatchingRemove(Predicate<String> predicate) {
    for (String item: remove) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingRemove(Predicate<String> predicate) {
    for (String item: remove) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withRemove(List<String> remove) {
    if (remove != null) {this.remove = new ArrayList(); for (String item : remove){this.addToRemove(item);}} else { this.remove = null;} return (A) this;
  }
  
  public A withRemove(java.lang.String... remove) {
    if (this.remove != null) {this.remove.clear(); _visitables.remove("remove"); }
    if (remove != null) {for (String item :remove){ this.addToRemove(item);}} return (A) this;
  }
  
  public boolean hasRemove() {
    return remove != null && !remove.isEmpty();
  }
  
  public A addToSet(String key,String value) {
    if(this.set == null && key != null && value != null) { this.set = new LinkedHashMap(); }
    if(key != null && value != null) {this.set.put(key, value);} return (A)this;
  }
  
  public A addToSet(Map<String,String> map) {
    if(this.set == null && map != null) { this.set = new LinkedHashMap(); }
    if(map != null) { this.set.putAll(map);} return (A)this;
  }
  
  public A removeFromSet(String key) {
    if(this.set == null) { return (A) this; }
    if(key != null && this.set != null) {this.set.remove(key);} return (A)this;
  }
  
  public A removeFromSet(Map<String,String> map) {
    if(this.set == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.set != null){this.set.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getSet() {
    return this.set;
  }
  
  public <K,V>A withSet(Map<String,String> set) {
    if (set == null) { this.set =  null;} else {this.set = new LinkedHashMap(set);} return (A) this;
  }
  
  public boolean hasSet() {
    return this.set != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HeadersHeaderOperationsFluent that = (HeadersHeaderOperationsFluent) o;
    if (!java.util.Objects.equals(add, that.add)) return false;
  
    if (!java.util.Objects.equals(remove, that.remove)) return false;
  
    if (!java.util.Objects.equals(set, that.set)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(add,  remove,  set,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (add != null && !add.isEmpty()) { sb.append("add:"); sb.append(add + ","); }
    if (remove != null && !remove.isEmpty()) { sb.append("remove:"); sb.append(remove + ","); }
    if (set != null && !set.isEmpty()) { sb.append("set:"); sb.append(set); }
    sb.append("}");
    return sb.toString();
  }
  

}