package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HTTPRetryBuilder extends HTTPRetryFluent<HTTPRetryBuilder> implements VisitableBuilder<HTTPRetry,HTTPRetryBuilder>{
  public HTTPRetryBuilder() {
    this(new HTTPRetry());
  }
  
  public HTTPRetryBuilder(HTTPRetryFluent<?> fluent) {
    this(fluent, new HTTPRetry());
  }
  
  public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,HTTPRetry instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HTTPRetryBuilder(HTTPRetry instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HTTPRetryFluent<?> fluent;
  
  public HTTPRetry build() {
    HTTPRetry buildable = new HTTPRetry(fluent.getAttempts(),fluent.getPerTryTimeout(),fluent.getRetryOn(),fluent.getRetryRemoteLocalities());
    return buildable;
  }
  

}