package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPFaultInjectionDelayFluent<A extends HTTPFaultInjectionDelayFluent<A>> extends BaseFluent<A>{
  public HTTPFaultInjectionDelayFluent() {
  }
  
  public HTTPFaultInjectionDelayFluent(HTTPFaultInjectionDelay instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsHTTPFaultInjectionDelayHttpDelayType,?> httpDelayType;
  private Integer percent;
  private PercentBuilder percentage;
  
  protected void copyInstance(HTTPFaultInjectionDelay instance) {
    instance = (instance != null ? instance : new HTTPFaultInjectionDelay());
  
    if (instance != null) {
        this.withHttpDelayType(instance.getHttpDelayType());
        this.withPercent(instance.getPercent());
        this.withPercentage(instance.getPercentage());
        this.withHttpDelayType(instance.getHttpDelayType());
        this.withPercent(instance.getPercent());
        this.withPercentage(instance.getPercentage());
      }
  }
  
  public IsHTTPFaultInjectionDelayHttpDelayType buildHttpDelayType() {
    return this.httpDelayType!=null?this.httpDelayType.build():null;
  }
  
  public A withHttpDelayType(IsHTTPFaultInjectionDelayHttpDelayType httpDelayType) {
    if (httpDelayType==null){ this.httpDelayType = null; _visitables.remove("httpDelayType"); return (A) this;}
    VisitableBuilder<? extends IsHTTPFaultInjectionDelayHttpDelayType,?> builder = builder(httpDelayType); _visitables.get("httpDelayType").clear();_visitables.get("httpDelayType").add(builder);this.httpDelayType = builder;
    return (A) this;
  }
  
  public boolean hasHttpDelayType() {
    return this.httpDelayType != null;
  }
  
  public HTTPFaultInjectionDelayFixedHttpTypeNested<A> withNewHTTPFaultInjectionDelayFixedHttpType() {
    return new HTTPFaultInjectionDelayFixedHttpTypeNested(null);
  }
  
  public HTTPFaultInjectionDelayFixedHttpTypeNested<A> withNewHTTPFaultInjectionDelayFixedHttpTypeLike(HTTPFaultInjectionDelayFixedDelay item) {
    return new HTTPFaultInjectionDelayFixedHttpTypeNested(item);
  }
  
  public A withNewHTTPFaultInjectionDelayFixedHttpType(String fixedDelay) {
    return (A)withHttpDelayType(new HTTPFaultInjectionDelayFixedDelay(fixedDelay));
  }
  
  public HTTPFaultInjectionDelayExponentialHttpTypeNested<A> withNewHTTPFaultInjectionDelayExponentialHttpType() {
    return new HTTPFaultInjectionDelayExponentialHttpTypeNested(null);
  }
  
  public HTTPFaultInjectionDelayExponentialHttpTypeNested<A> withNewHTTPFaultInjectionDelayExponentialHttpTypeLike(HTTPFaultInjectionDelayExponentialDelay item) {
    return new HTTPFaultInjectionDelayExponentialHttpTypeNested(item);
  }
  
  public A withNewHTTPFaultInjectionDelayExponentialHttpType(String exponentialDelay) {
    return (A)withHttpDelayType(new HTTPFaultInjectionDelayExponentialDelay(exponentialDelay));
  }
  
  public Integer getPercent() {
    return this.percent;
  }
  
  public A withPercent(Integer percent) {
    this.percent=percent; return (A) this;
  }
  
  public boolean hasPercent() {
    return this.percent != null;
  }
  
  public Percent buildPercentage() {
    return this.percentage!=null ?this.percentage.build():null;
  }
  
  public A withPercentage(Percent percentage) {
    _visitables.get("percentage").remove(this.percentage);
    if (percentage!=null){ this.percentage= new PercentBuilder(percentage); _visitables.get("percentage").add(this.percentage);} else { this.percentage = null; _visitables.get("percentage").remove(this.percentage); } return (A) this;
  }
  
  public boolean hasPercentage() {
    return this.percentage != null;
  }
  
  public A withNewPercentage(Double value) {
    return (A)withPercentage(new Percent(value));
  }
  
  public PercentageNested<A> withNewPercentage() {
    return new PercentageNested(null);
  }
  
  public PercentageNested<A> withNewPercentageLike(Percent item) {
    return new PercentageNested(item);
  }
  
  public PercentageNested<A> editPercentage() {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(null));
  }
  
  public PercentageNested<A> editOrNewPercentage() {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(new PercentBuilder().build()));
  }
  
  public PercentageNested<A> editOrNewPercentageLike(Percent item) {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPFaultInjectionDelayFluent that = (HTTPFaultInjectionDelayFluent) o;
    if (!java.util.Objects.equals(httpDelayType, that.httpDelayType)) return false;
  
    if (!java.util.Objects.equals(percent, that.percent)) return false;
  
    if (!java.util.Objects.equals(percentage, that.percentage)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpDelayType,  percent,  percentage,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpDelayType != null) { sb.append("httpDelayType:"); sb.append(httpDelayType + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (percentage != null) { sb.append("percentage:"); sb.append(percentage); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1alpha3."+"HTTPFaultInjectionDelayFixedDelay": return (VisitableBuilder<T, ?>)new HTTPFaultInjectionDelayFixedDelayBuilder((HTTPFaultInjectionDelayFixedDelay) item);
    case "io.fabric8.istio.api.networking.v1alpha3."+"HTTPFaultInjectionDelayExponentialDelay": return (VisitableBuilder<T, ?>)new HTTPFaultInjectionDelayExponentialDelayBuilder((HTTPFaultInjectionDelayExponentialDelay) item);
    }
   return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class HTTPFaultInjectionDelayFixedHttpTypeNested<N> extends HTTPFaultInjectionDelayFixedDelayFluent<HTTPFaultInjectionDelayFixedHttpTypeNested<N>> implements Nested<N>{
    HTTPFaultInjectionDelayFixedHttpTypeNested(HTTPFaultInjectionDelayFixedDelay item) {
      this.builder = new HTTPFaultInjectionDelayFixedDelayBuilder(this, item);
    }
    HTTPFaultInjectionDelayFixedDelayBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionDelayFluent.this.withHttpDelayType(builder.build());
    }
    
    public N endHTTPFaultInjectionDelayFixedHttpType() {
      return and();
    }
    
  
  }
  public class HTTPFaultInjectionDelayExponentialHttpTypeNested<N> extends HTTPFaultInjectionDelayExponentialDelayFluent<HTTPFaultInjectionDelayExponentialHttpTypeNested<N>> implements Nested<N>{
    HTTPFaultInjectionDelayExponentialHttpTypeNested(HTTPFaultInjectionDelayExponentialDelay item) {
      this.builder = new HTTPFaultInjectionDelayExponentialDelayBuilder(this, item);
    }
    HTTPFaultInjectionDelayExponentialDelayBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionDelayFluent.this.withHttpDelayType(builder.build());
    }
    
    public N endHTTPFaultInjectionDelayExponentialHttpType() {
      return and();
    }
    
  
  }
  public class PercentageNested<N> extends PercentFluent<PercentageNested<N>> implements Nested<N>{
    PercentageNested(Percent item) {
      this.builder = new PercentBuilder(this, item);
    }
    PercentBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionDelayFluent.this.withPercentage(builder.build());
    }
    
    public N endPercentage() {
      return and();
    }
    
  
  }

}