package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EnvoyFilterRouteConfigurationMatchFluent<A extends EnvoyFilterRouteConfigurationMatchFluent<A>> extends BaseFluent<A>{
  public EnvoyFilterRouteConfigurationMatchFluent() {
  }
  
  public EnvoyFilterRouteConfigurationMatchFluent(EnvoyFilterRouteConfigurationMatch instance) {
    this.copyInstance(instance);
  }
  private String gateway;
  private String name;
  private String portName;
  private Integer portNumber;
  private EnvoyFilterRouteConfigurationMatchVirtualHostMatchBuilder vhost;
  
  protected void copyInstance(EnvoyFilterRouteConfigurationMatch instance) {
    instance = (instance != null ? instance : new EnvoyFilterRouteConfigurationMatch());
  
    if (instance != null) {
        this.withGateway(instance.getGateway());
        this.withName(instance.getName());
        this.withPortName(instance.getPortName());
        this.withPortNumber(instance.getPortNumber());
        this.withVhost(instance.getVhost());
        this.withGateway(instance.getGateway());
        this.withName(instance.getName());
        this.withPortName(instance.getPortName());
        this.withPortNumber(instance.getPortNumber());
        this.withVhost(instance.getVhost());
      }
  }
  
  public String getGateway() {
    return this.gateway;
  }
  
  public A withGateway(String gateway) {
    this.gateway=gateway; return (A) this;
  }
  
  public boolean hasGateway() {
    return this.gateway != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getPortName() {
    return this.portName;
  }
  
  public A withPortName(String portName) {
    this.portName=portName; return (A) this;
  }
  
  public boolean hasPortName() {
    return this.portName != null;
  }
  
  public Integer getPortNumber() {
    return this.portNumber;
  }
  
  public A withPortNumber(Integer portNumber) {
    this.portNumber=portNumber; return (A) this;
  }
  
  public boolean hasPortNumber() {
    return this.portNumber != null;
  }
  
  public EnvoyFilterRouteConfigurationMatchVirtualHostMatch buildVhost() {
    return this.vhost!=null ?this.vhost.build():null;
  }
  
  public A withVhost(EnvoyFilterRouteConfigurationMatchVirtualHostMatch vhost) {
    _visitables.get("vhost").remove(this.vhost);
    if (vhost!=null){ this.vhost= new EnvoyFilterRouteConfigurationMatchVirtualHostMatchBuilder(vhost); _visitables.get("vhost").add(this.vhost);} else { this.vhost = null; _visitables.get("vhost").remove(this.vhost); } return (A) this;
  }
  
  public boolean hasVhost() {
    return this.vhost != null;
  }
  
  public VhostNested<A> withNewVhost() {
    return new VhostNested(null);
  }
  
  public VhostNested<A> withNewVhostLike(EnvoyFilterRouteConfigurationMatchVirtualHostMatch item) {
    return new VhostNested(item);
  }
  
  public VhostNested<A> editVhost() {
    return withNewVhostLike(java.util.Optional.ofNullable(buildVhost()).orElse(null));
  }
  
  public VhostNested<A> editOrNewVhost() {
    return withNewVhostLike(java.util.Optional.ofNullable(buildVhost()).orElse(new EnvoyFilterRouteConfigurationMatchVirtualHostMatchBuilder().build()));
  }
  
  public VhostNested<A> editOrNewVhostLike(EnvoyFilterRouteConfigurationMatchVirtualHostMatch item) {
    return withNewVhostLike(java.util.Optional.ofNullable(buildVhost()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EnvoyFilterRouteConfigurationMatchFluent that = (EnvoyFilterRouteConfigurationMatchFluent) o;
    if (!java.util.Objects.equals(gateway, that.gateway)) return false;
  
    if (!java.util.Objects.equals(name, that.name)) return false;
  
    if (!java.util.Objects.equals(portName, that.portName)) return false;
  
    if (!java.util.Objects.equals(portNumber, that.portNumber)) return false;
  
    if (!java.util.Objects.equals(vhost, that.vhost)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(gateway,  name,  portName,  portNumber,  vhost,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (gateway != null) { sb.append("gateway:"); sb.append(gateway + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (portName != null) { sb.append("portName:"); sb.append(portName + ","); }
    if (portNumber != null) { sb.append("portNumber:"); sb.append(portNumber + ","); }
    if (vhost != null) { sb.append("vhost:"); sb.append(vhost); }
    sb.append("}");
    return sb.toString();
  }
  public class VhostNested<N> extends EnvoyFilterRouteConfigurationMatchVirtualHostMatchFluent<VhostNested<N>> implements Nested<N>{
    VhostNested(EnvoyFilterRouteConfigurationMatchVirtualHostMatch item) {
      this.builder = new EnvoyFilterRouteConfigurationMatchVirtualHostMatchBuilder(this, item);
    }
    EnvoyFilterRouteConfigurationMatchVirtualHostMatchBuilder builder;
    
    public N and() {
      return (N) EnvoyFilterRouteConfigurationMatchFluent.this.withVhost(builder.build());
    }
    
    public N endVhost() {
      return and();
    }
    
  
  }

}