package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DestinationRuleSpecFluent<A extends DestinationRuleSpecFluent<A>> extends BaseFluent<A>{
  public DestinationRuleSpecFluent() {
  }
  
  public DestinationRuleSpecFluent(DestinationRuleSpec instance) {
    this.copyInstance(instance);
  }
  private List<String> exportTo = new ArrayList<String>();
  private String host;
  private ArrayList<SubsetBuilder> subsets = new ArrayList<SubsetBuilder>();
  private TrafficPolicyBuilder trafficPolicy;
  
  protected void copyInstance(DestinationRuleSpec instance) {
    instance = (instance != null ? instance : new DestinationRuleSpec());
  
    if (instance != null) {
        this.withExportTo(instance.getExportTo());
        this.withHost(instance.getHost());
        this.withSubsets(instance.getSubsets());
        this.withTrafficPolicy(instance.getTrafficPolicy());
        this.withExportTo(instance.getExportTo());
        this.withHost(instance.getHost());
        this.withSubsets(instance.getSubsets());
        this.withTrafficPolicy(instance.getTrafficPolicy());
      }
  }
  
  public A addToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.add(index, item);
    return (A)this;
  }
  
  public A setToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.set(index, item); return (A)this;
  }
  
  public A addToExportTo(java.lang.String... items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  
  public A addAllToExportTo(Collection<String> items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  
  public A removeFromExportTo(java.lang.String... items) {
    if (this.exportTo == null) return (A)this;
    for (String item : items) { this.exportTo.remove(item);} return (A)this;
  }
  
  public A removeAllFromExportTo(Collection<String> items) {
    if (this.exportTo == null) return (A)this;
    for (String item : items) { this.exportTo.remove(item);} return (A)this;
  }
  
  public List<String> getExportTo() {
    return this.exportTo;
  }
  
  public String getExportTo(int index) {
    return this.exportTo.get(index);
  }
  
  public String getFirstExportTo() {
    return this.exportTo.get(0);
  }
  
  public String getLastExportTo() {
    return this.exportTo.get(exportTo.size() - 1);
  }
  
  public String getMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withExportTo(List<String> exportTo) {
    if (exportTo != null) {this.exportTo = new ArrayList(); for (String item : exportTo){this.addToExportTo(item);}} else { this.exportTo = null;} return (A) this;
  }
  
  public A withExportTo(java.lang.String... exportTo) {
    if (this.exportTo != null) {this.exportTo.clear(); _visitables.remove("exportTo"); }
    if (exportTo != null) {for (String item :exportTo){ this.addToExportTo(item);}} return (A) this;
  }
  
  public boolean hasExportTo() {
    return exportTo != null && !exportTo.isEmpty();
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public A addToSubsets(int index,Subset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    SubsetBuilder builder = new SubsetBuilder(item);
    if (index < 0 || index >= subsets.size()) { _visitables.get("subsets").add(builder); subsets.add(builder); } else { _visitables.get("subsets").add(index, builder); subsets.add(index, builder);}
    return (A)this;
  }
  
  public A setToSubsets(int index,Subset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    SubsetBuilder builder = new SubsetBuilder(item);
    if (index < 0 || index >= subsets.size()) { _visitables.get("subsets").add(builder); subsets.add(builder); } else { _visitables.get("subsets").set(index, builder); subsets.set(index, builder);}
    return (A)this;
  }
  
  public A addToSubsets(io.fabric8.istio.api.networking.v1alpha3.Subset... items) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  
  public A addAllToSubsets(Collection<Subset> items) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  
  public A removeFromSubsets(io.fabric8.istio.api.networking.v1alpha3.Subset... items) {
    if (this.subsets == null) return (A)this;
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").remove(builder); this.subsets.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSubsets(Collection<Subset> items) {
    if (this.subsets == null) return (A)this;
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").remove(builder); this.subsets.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSubsets(Predicate<SubsetBuilder> predicate) {
    if (subsets == null) return (A) this;
    final Iterator<SubsetBuilder> each = subsets.iterator();
    final List visitables = _visitables.get("subsets");
    while (each.hasNext()) {
      SubsetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Subset> buildSubsets() {
    return subsets != null ? build(subsets) : null;
  }
  
  public Subset buildSubset(int index) {
    return this.subsets.get(index).build();
  }
  
  public Subset buildFirstSubset() {
    return this.subsets.get(0).build();
  }
  
  public Subset buildLastSubset() {
    return this.subsets.get(subsets.size() - 1).build();
  }
  
  public Subset buildMatchingSubset(Predicate<SubsetBuilder> predicate) {
    for (SubsetBuilder item: subsets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingSubset(Predicate<SubsetBuilder> predicate) {
    for (SubsetBuilder item: subsets) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withSubsets(List<Subset> subsets) {
    if (this.subsets != null) { _visitables.get("subsets").clear();}
    if (subsets != null) {this.subsets = new ArrayList(); for (Subset item : subsets){this.addToSubsets(item);}} else { this.subsets = null;} return (A) this;
  }
  
  public A withSubsets(io.fabric8.istio.api.networking.v1alpha3.Subset... subsets) {
    if (this.subsets != null) {this.subsets.clear(); _visitables.remove("subsets"); }
    if (subsets != null) {for (Subset item :subsets){ this.addToSubsets(item);}} return (A) this;
  }
  
  public boolean hasSubsets() {
    return subsets != null && !subsets.isEmpty();
  }
  
  public SubsetsNested<A> addNewSubset() {
    return new SubsetsNested(-1, null);
  }
  
  public SubsetsNested<A> addNewSubsetLike(Subset item) {
    return new SubsetsNested(-1, item);
  }
  
  public SubsetsNested<A> setNewSubsetLike(int index,Subset item) {
    return new SubsetsNested(index, item);
  }
  
  public SubsetsNested<A> editSubset(int index) {
    if (subsets.size() <= index) throw new RuntimeException("Can't edit subsets. Index exceeds size.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  
  public SubsetsNested<A> editFirstSubset() {
    if (subsets.size() == 0) throw new RuntimeException("Can't edit first subsets. The list is empty.");
    return setNewSubsetLike(0, buildSubset(0));
  }
  
  public SubsetsNested<A> editLastSubset() {
    int index = subsets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subsets. The list is empty.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  
  public SubsetsNested<A> editMatchingSubset(Predicate<SubsetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subsets.size();i++) { 
    if (predicate.test(subsets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subsets. No match found.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  
  public TrafficPolicy buildTrafficPolicy() {
    return this.trafficPolicy!=null ?this.trafficPolicy.build():null;
  }
  
  public A withTrafficPolicy(TrafficPolicy trafficPolicy) {
    _visitables.get("trafficPolicy").remove(this.trafficPolicy);
    if (trafficPolicy!=null){ this.trafficPolicy= new TrafficPolicyBuilder(trafficPolicy); _visitables.get("trafficPolicy").add(this.trafficPolicy);} else { this.trafficPolicy = null; _visitables.get("trafficPolicy").remove(this.trafficPolicy); } return (A) this;
  }
  
  public boolean hasTrafficPolicy() {
    return this.trafficPolicy != null;
  }
  
  public TrafficPolicyNested<A> withNewTrafficPolicy() {
    return new TrafficPolicyNested(null);
  }
  
  public TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item) {
    return new TrafficPolicyNested(item);
  }
  
  public TrafficPolicyNested<A> editTrafficPolicy() {
    return withNewTrafficPolicyLike(java.util.Optional.ofNullable(buildTrafficPolicy()).orElse(null));
  }
  
  public TrafficPolicyNested<A> editOrNewTrafficPolicy() {
    return withNewTrafficPolicyLike(java.util.Optional.ofNullable(buildTrafficPolicy()).orElse(new TrafficPolicyBuilder().build()));
  }
  
  public TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item) {
    return withNewTrafficPolicyLike(java.util.Optional.ofNullable(buildTrafficPolicy()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DestinationRuleSpecFluent that = (DestinationRuleSpecFluent) o;
    if (!java.util.Objects.equals(exportTo, that.exportTo)) return false;
  
    if (!java.util.Objects.equals(host, that.host)) return false;
  
    if (!java.util.Objects.equals(subsets, that.subsets)) return false;
  
    if (!java.util.Objects.equals(trafficPolicy, that.trafficPolicy)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(exportTo,  host,  subsets,  trafficPolicy,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (exportTo != null && !exportTo.isEmpty()) { sb.append("exportTo:"); sb.append(exportTo + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (subsets != null && !subsets.isEmpty()) { sb.append("subsets:"); sb.append(subsets + ","); }
    if (trafficPolicy != null) { sb.append("trafficPolicy:"); sb.append(trafficPolicy); }
    sb.append("}");
    return sb.toString();
  }
  public class SubsetsNested<N> extends SubsetFluent<SubsetsNested<N>> implements Nested<N>{
    SubsetsNested(int index,Subset item) {
      this.index = index;
      this.builder = new SubsetBuilder(this, item);
    }
    SubsetBuilder builder;
    int index;
    
    public N and() {
      return (N) DestinationRuleSpecFluent.this.setToSubsets(index,builder.build());
    }
    
    public N endSubset() {
      return and();
    }
    
  
  }
  public class TrafficPolicyNested<N> extends TrafficPolicyFluent<TrafficPolicyNested<N>> implements Nested<N>{
    TrafficPolicyNested(TrafficPolicy item) {
      this.builder = new TrafficPolicyBuilder(this, item);
    }
    TrafficPolicyBuilder builder;
    
    public N and() {
      return (N) DestinationRuleSpecFluent.this.withTrafficPolicy(builder.build());
    }
    
    public N endTrafficPolicy() {
      return and();
    }
    
  
  }

}