package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DelegateBuilder extends DelegateFluent<DelegateBuilder> implements VisitableBuilder<Delegate,DelegateBuilder>{
  public DelegateBuilder() {
    this(new Delegate());
  }
  
  public DelegateBuilder(DelegateFluent<?> fluent) {
    this(fluent, new Delegate());
  }
  
  public DelegateBuilder(DelegateFluent<?> fluent,Delegate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DelegateBuilder(Delegate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DelegateFluent<?> fluent;
  
  public Delegate build() {
    Delegate buildable = new Delegate(fluent.getName(),fluent.getNamespace());
    return buildable;
  }
  

}