package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConnectionPoolSettingsHTTPSettingsFluent<A extends ConnectionPoolSettingsHTTPSettingsFluent<A>> extends BaseFluent<A>{
  public ConnectionPoolSettingsHTTPSettingsFluent() {
  }
  
  public ConnectionPoolSettingsHTTPSettingsFluent(ConnectionPoolSettingsHTTPSettings instance) {
    this.copyInstance(instance);
  }
  private ConnectionPoolSettingsHTTPSettingsH2UpgradePolicy h2UpgradePolicy;
  private Integer http1MaxPendingRequests;
  private Integer http2MaxRequests;
  private String idleTimeout;
  private Integer maxRequestsPerConnection;
  private Integer maxRetries;
  private Boolean useClientProtocol;
  
  protected void copyInstance(ConnectionPoolSettingsHTTPSettings instance) {
    instance = (instance != null ? instance : new ConnectionPoolSettingsHTTPSettings());
  
    if (instance != null) {
        this.withH2UpgradePolicy(instance.getH2UpgradePolicy());
        this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests());
        this.withHttp2MaxRequests(instance.getHttp2MaxRequests());
        this.withIdleTimeout(instance.getIdleTimeout());
        this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection());
        this.withMaxRetries(instance.getMaxRetries());
        this.withUseClientProtocol(instance.getUseClientProtocol());
        this.withH2UpgradePolicy(instance.getH2UpgradePolicy());
        this.withHttp1MaxPendingRequests(instance.getHttp1MaxPendingRequests());
        this.withHttp2MaxRequests(instance.getHttp2MaxRequests());
        this.withIdleTimeout(instance.getIdleTimeout());
        this.withMaxRequestsPerConnection(instance.getMaxRequestsPerConnection());
        this.withMaxRetries(instance.getMaxRetries());
        this.withUseClientProtocol(instance.getUseClientProtocol());
      }
  }
  
  public ConnectionPoolSettingsHTTPSettingsH2UpgradePolicy getH2UpgradePolicy() {
    return this.h2UpgradePolicy;
  }
  
  public A withH2UpgradePolicy(ConnectionPoolSettingsHTTPSettingsH2UpgradePolicy h2UpgradePolicy) {
    this.h2UpgradePolicy=h2UpgradePolicy; return (A) this;
  }
  
  public boolean hasH2UpgradePolicy() {
    return this.h2UpgradePolicy != null;
  }
  
  public Integer getHttp1MaxPendingRequests() {
    return this.http1MaxPendingRequests;
  }
  
  public A withHttp1MaxPendingRequests(Integer http1MaxPendingRequests) {
    this.http1MaxPendingRequests=http1MaxPendingRequests; return (A) this;
  }
  
  public boolean hasHttp1MaxPendingRequests() {
    return this.http1MaxPendingRequests != null;
  }
  
  public Integer getHttp2MaxRequests() {
    return this.http2MaxRequests;
  }
  
  public A withHttp2MaxRequests(Integer http2MaxRequests) {
    this.http2MaxRequests=http2MaxRequests; return (A) this;
  }
  
  public boolean hasHttp2MaxRequests() {
    return this.http2MaxRequests != null;
  }
  
  public String getIdleTimeout() {
    return this.idleTimeout;
  }
  
  public A withIdleTimeout(String idleTimeout) {
    this.idleTimeout=idleTimeout; return (A) this;
  }
  
  public boolean hasIdleTimeout() {
    return this.idleTimeout != null;
  }
  
  public Integer getMaxRequestsPerConnection() {
    return this.maxRequestsPerConnection;
  }
  
  public A withMaxRequestsPerConnection(Integer maxRequestsPerConnection) {
    this.maxRequestsPerConnection=maxRequestsPerConnection; return (A) this;
  }
  
  public boolean hasMaxRequestsPerConnection() {
    return this.maxRequestsPerConnection != null;
  }
  
  public Integer getMaxRetries() {
    return this.maxRetries;
  }
  
  public A withMaxRetries(Integer maxRetries) {
    this.maxRetries=maxRetries; return (A) this;
  }
  
  public boolean hasMaxRetries() {
    return this.maxRetries != null;
  }
  
  public Boolean getUseClientProtocol() {
    return this.useClientProtocol;
  }
  
  public A withUseClientProtocol(Boolean useClientProtocol) {
    this.useClientProtocol=useClientProtocol; return (A) this;
  }
  
  public boolean hasUseClientProtocol() {
    return this.useClientProtocol != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConnectionPoolSettingsHTTPSettingsFluent that = (ConnectionPoolSettingsHTTPSettingsFluent) o;
    if (!java.util.Objects.equals(h2UpgradePolicy, that.h2UpgradePolicy)) return false;
  
    if (!java.util.Objects.equals(http1MaxPendingRequests, that.http1MaxPendingRequests)) return false;
  
    if (!java.util.Objects.equals(http2MaxRequests, that.http2MaxRequests)) return false;
  
    if (!java.util.Objects.equals(idleTimeout, that.idleTimeout)) return false;
  
    if (!java.util.Objects.equals(maxRequestsPerConnection, that.maxRequestsPerConnection)) return false;
  
    if (!java.util.Objects.equals(maxRetries, that.maxRetries)) return false;
  
    if (!java.util.Objects.equals(useClientProtocol, that.useClientProtocol)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(h2UpgradePolicy,  http1MaxPendingRequests,  http2MaxRequests,  idleTimeout,  maxRequestsPerConnection,  maxRetries,  useClientProtocol,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (h2UpgradePolicy != null) { sb.append("h2UpgradePolicy:"); sb.append(h2UpgradePolicy + ","); }
    if (http1MaxPendingRequests != null) { sb.append("http1MaxPendingRequests:"); sb.append(http1MaxPendingRequests + ","); }
    if (http2MaxRequests != null) { sb.append("http2MaxRequests:"); sb.append(http2MaxRequests + ","); }
    if (idleTimeout != null) { sb.append("idleTimeout:"); sb.append(idleTimeout + ","); }
    if (maxRequestsPerConnection != null) { sb.append("maxRequestsPerConnection:"); sb.append(maxRequestsPerConnection + ","); }
    if (maxRetries != null) { sb.append("maxRetries:"); sb.append(maxRetries + ","); }
    if (useClientProtocol != null) { sb.append("useClientProtocol:"); sb.append(useClientProtocol); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withUseClientProtocol() {
    return withUseClientProtocol(true);
  }
  

}