package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Double;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ValueFluent<A extends ValueFluent<A>> extends BaseFluent<A>{
  public ValueFluent() {
  }
  
  public ValueFluent(Value instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsValueKind,?> kind;
  
  protected void copyInstance(Value instance) {
    instance = (instance != null ? instance : new Value());
  
    if (instance != null) {
        this.withKind(instance.getKind());
        this.withKind(instance.getKind());
      }
  }
  
  public IsValueKind buildKind() {
    return this.kind!=null?this.kind.build():null;
  }
  
  public A withKind(IsValueKind kind) {
    if (kind==null){ this.kind = null; _visitables.remove("kind"); return (A) this;}
    VisitableBuilder<? extends IsValueKind,?> builder = builder(kind); _visitables.get("kind").clear();_visitables.get("kind").add(builder);this.kind = builder;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ValueListValueKindNested<A> withNewValueListValueKind() {
    return new ValueListValueKindNested(null);
  }
  
  public ValueListValueKindNested<A> withNewValueListValueKindLike(ValueListValue item) {
    return new ValueListValueKindNested(item);
  }
  
  public ValueNullValueKindNested<A> withNewValueNullValueKind() {
    return new ValueNullValueKindNested(null);
  }
  
  public ValueNullValueKindNested<A> withNewValueNullValueKindLike(ValueNullValue item) {
    return new ValueNullValueKindNested(item);
  }
  
  public ValueStringValueKindNested<A> withNewValueStringValueKind() {
    return new ValueStringValueKindNested(null);
  }
  
  public ValueStringValueKindNested<A> withNewValueStringValueKindLike(ValueStringValue item) {
    return new ValueStringValueKindNested(item);
  }
  
  public A withNewValueStringValueKind(String stringValue) {
    return (A)withKind(new ValueStringValue(stringValue));
  }
  
  public ValueStructValueKindNested<A> withNewValueStructValueKind() {
    return new ValueStructValueKindNested(null);
  }
  
  public ValueStructValueKindNested<A> withNewValueStructValueKindLike(ValueStructValue item) {
    return new ValueStructValueKindNested(item);
  }
  
  public ValueBoolValueKindNested<A> withNewValueBoolValueKind() {
    return new ValueBoolValueKindNested(null);
  }
  
  public ValueBoolValueKindNested<A> withNewValueBoolValueKindLike(ValueBoolValue item) {
    return new ValueBoolValueKindNested(item);
  }
  
  public A withNewValueBoolValueKind(Boolean boolValue) {
    return (A)withKind(new ValueBoolValue(boolValue));
  }
  
  public ValueNumberValueKindNested<A> withNewValueNumberValueKind() {
    return new ValueNumberValueKindNested(null);
  }
  
  public ValueNumberValueKindNested<A> withNewValueNumberValueKindLike(ValueNumberValue item) {
    return new ValueNumberValueKindNested(item);
  }
  
  public A withNewValueNumberValueKind(Double numberValue) {
    return (A)withKind(new ValueNumberValue(numberValue));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValueFluent that = (ValueFluent) o;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(kind,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kind != null) { sb.append("kind:"); sb.append(kind); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.internal.protobuf.types."+"ValueListValue": return (VisitableBuilder<T, ?>)new ValueListValueBuilder((ValueListValue) item);
    case "io.fabric8.istio.api.internal.protobuf.types."+"ValueNullValue": return (VisitableBuilder<T, ?>)new ValueNullValueBuilder((ValueNullValue) item);
    case "io.fabric8.istio.api.internal.protobuf.types."+"ValueStringValue": return (VisitableBuilder<T, ?>)new ValueStringValueBuilder((ValueStringValue) item);
    case "io.fabric8.istio.api.internal.protobuf.types."+"ValueStructValue": return (VisitableBuilder<T, ?>)new ValueStructValueBuilder((ValueStructValue) item);
    case "io.fabric8.istio.api.internal.protobuf.types."+"ValueBoolValue": return (VisitableBuilder<T, ?>)new ValueBoolValueBuilder((ValueBoolValue) item);
    case "io.fabric8.istio.api.internal.protobuf.types."+"ValueNumberValue": return (VisitableBuilder<T, ?>)new ValueNumberValueBuilder((ValueNumberValue) item);
    }
   return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class ValueListValueKindNested<N> extends ValueListValueFluent<ValueListValueKindNested<N>> implements Nested<N>{
    ValueListValueKindNested(ValueListValue item) {
      this.builder = new ValueListValueBuilder(this, item);
    }
    ValueListValueBuilder builder;
    
    public N and() {
      return (N) ValueFluent.this.withKind(builder.build());
    }
    
    public N endValueListValueKind() {
      return and();
    }
    
  
  }
  public class ValueNullValueKindNested<N> extends ValueNullValueFluent<ValueNullValueKindNested<N>> implements Nested<N>{
    ValueNullValueKindNested(ValueNullValue item) {
      this.builder = new ValueNullValueBuilder(this, item);
    }
    ValueNullValueBuilder builder;
    
    public N and() {
      return (N) ValueFluent.this.withKind(builder.build());
    }
    
    public N endValueNullValueKind() {
      return and();
    }
    
  
  }
  public class ValueStringValueKindNested<N> extends ValueStringValueFluent<ValueStringValueKindNested<N>> implements Nested<N>{
    ValueStringValueKindNested(ValueStringValue item) {
      this.builder = new ValueStringValueBuilder(this, item);
    }
    ValueStringValueBuilder builder;
    
    public N and() {
      return (N) ValueFluent.this.withKind(builder.build());
    }
    
    public N endValueStringValueKind() {
      return and();
    }
    
  
  }
  public class ValueStructValueKindNested<N> extends ValueStructValueFluent<ValueStructValueKindNested<N>> implements Nested<N>{
    ValueStructValueKindNested(ValueStructValue item) {
      this.builder = new ValueStructValueBuilder(this, item);
    }
    ValueStructValueBuilder builder;
    
    public N and() {
      return (N) ValueFluent.this.withKind(builder.build());
    }
    
    public N endValueStructValueKind() {
      return and();
    }
    
  
  }
  public class ValueBoolValueKindNested<N> extends ValueBoolValueFluent<ValueBoolValueKindNested<N>> implements Nested<N>{
    ValueBoolValueKindNested(ValueBoolValue item) {
      this.builder = new ValueBoolValueBuilder(this, item);
    }
    ValueBoolValueBuilder builder;
    
    public N and() {
      return (N) ValueFluent.this.withKind(builder.build());
    }
    
    public N endValueBoolValueKind() {
      return and();
    }
    
  
  }
  public class ValueNumberValueKindNested<N> extends ValueNumberValueFluent<ValueNumberValueKindNested<N>> implements Nested<N>{
    ValueNumberValueKindNested(ValueNumberValue item) {
      this.builder = new ValueNumberValueBuilder(this, item);
    }
    ValueNumberValueBuilder builder;
    
    public N and() {
      return (N) ValueFluent.this.withKind(builder.build());
    }
    
    public N endValueNumberValueKind() {
      return and();
    }
    
  
  }

}