package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ListValueFluent<A extends ListValueFluent<A>> extends BaseFluent<A>{
  public ListValueFluent() {
  }
  
  public ListValueFluent(ListValue instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ValueBuilder> values = new ArrayList<ValueBuilder>();
  
  protected void copyInstance(ListValue instance) {
    instance = (instance != null ? instance : new ListValue());
  
    if (instance != null) {
        this.withValues(instance.getValues());
        this.withValues(instance.getValues());
      }
  }
  
  public A addToValues(int index,Value item) {
    if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
    ValueBuilder builder = new ValueBuilder(item);
    if (index < 0 || index >= values.size()) { _visitables.get("values").add(builder); values.add(builder); } else { _visitables.get("values").add(index, builder); values.add(index, builder);}
    return (A)this;
  }
  
  public A setToValues(int index,Value item) {
    if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
    ValueBuilder builder = new ValueBuilder(item);
    if (index < 0 || index >= values.size()) { _visitables.get("values").add(builder); values.add(builder); } else { _visitables.get("values").set(index, builder); values.set(index, builder);}
    return (A)this;
  }
  
  public A addToValues(io.fabric8.istio.api.internal.protobuf.types.Value... items) {
    if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
    for (Value item : items) {ValueBuilder builder = new ValueBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  
  public A addAllToValues(Collection<Value> items) {
    if (this.values == null) {this.values = new ArrayList<ValueBuilder>();}
    for (Value item : items) {ValueBuilder builder = new ValueBuilder(item);_visitables.get("values").add(builder);this.values.add(builder);} return (A)this;
  }
  
  public A removeFromValues(io.fabric8.istio.api.internal.protobuf.types.Value... items) {
    if (this.values == null) return (A)this;
    for (Value item : items) {ValueBuilder builder = new ValueBuilder(item);_visitables.get("values").remove(builder); this.values.remove(builder);} return (A)this;
  }
  
  public A removeAllFromValues(Collection<Value> items) {
    if (this.values == null) return (A)this;
    for (Value item : items) {ValueBuilder builder = new ValueBuilder(item);_visitables.get("values").remove(builder); this.values.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromValues(Predicate<ValueBuilder> predicate) {
    if (values == null) return (A) this;
    final Iterator<ValueBuilder> each = values.iterator();
    final List visitables = _visitables.get("values");
    while (each.hasNext()) {
      ValueBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Value> buildValues() {
    return values != null ? build(values) : null;
  }
  
  public Value buildValue(int index) {
    return this.values.get(index).build();
  }
  
  public Value buildFirstValue() {
    return this.values.get(0).build();
  }
  
  public Value buildLastValue() {
    return this.values.get(values.size() - 1).build();
  }
  
  public Value buildMatchingValue(Predicate<ValueBuilder> predicate) {
    for (ValueBuilder item: values) { if(predicate.test(item)){ return item.build();} } return null;
  }
  
  public boolean hasMatchingValue(Predicate<ValueBuilder> predicate) {
    for (ValueBuilder item: values) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withValues(List<Value> values) {
    if (this.values != null) { _visitables.get("values").clear();}
    if (values != null) {this.values = new ArrayList(); for (Value item : values){this.addToValues(item);}} else { this.values = null;} return (A) this;
  }
  
  public A withValues(io.fabric8.istio.api.internal.protobuf.types.Value... values) {
    if (this.values != null) {this.values.clear(); _visitables.remove("values"); }
    if (values != null) {for (Value item :values){ this.addToValues(item);}} return (A) this;
  }
  
  public boolean hasValues() {
    return values != null && !values.isEmpty();
  }
  
  public ValuesNested<A> addNewValue() {
    return new ValuesNested(-1, null);
  }
  
  public ValuesNested<A> addNewValueLike(Value item) {
    return new ValuesNested(-1, item);
  }
  
  public ValuesNested<A> setNewValueLike(int index,Value item) {
    return new ValuesNested(index, item);
  }
  
  public ValuesNested<A> editValue(int index) {
    if (values.size() <= index) throw new RuntimeException("Can't edit values. Index exceeds size.");
    return setNewValueLike(index, buildValue(index));
  }
  
  public ValuesNested<A> editFirstValue() {
    if (values.size() == 0) throw new RuntimeException("Can't edit first values. The list is empty.");
    return setNewValueLike(0, buildValue(0));
  }
  
  public ValuesNested<A> editLastValue() {
    int index = values.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last values. The list is empty.");
    return setNewValueLike(index, buildValue(index));
  }
  
  public ValuesNested<A> editMatchingValue(Predicate<ValueBuilder> predicate) {
    int index = -1;
    for (int i=0;i<values.size();i++) { 
    if (predicate.test(values.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching values. No match found.");
    return setNewValueLike(index, buildValue(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ListValueFluent that = (ListValueFluent) o;
    if (!java.util.Objects.equals(values, that.values)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(values,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (values != null && !values.isEmpty()) { sb.append("values:"); sb.append(values); }
    sb.append("}");
    return sb.toString();
  }
  public class ValuesNested<N> extends ValueFluent<ValuesNested<N>> implements Nested<N>{
    ValuesNested(int index,Value item) {
      this.index = index;
      this.builder = new ValueBuilder(this, item);
    }
    ValueBuilder builder;
    int index;
    
    public N and() {
      return (N) ListValueFluent.this.setToValues(index,builder.build());
    }
    
    public N endValue() {
      return and();
    }
    
  
  }

}