package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadEntryBuilder extends WorkloadEntryFluent<WorkloadEntryBuilder> implements VisitableBuilder<WorkloadEntry,WorkloadEntryBuilder>{
  public WorkloadEntryBuilder() {
    this(false);
  }
  public WorkloadEntryBuilder(Boolean validationEnabled) {
    this(new WorkloadEntry(), validationEnabled);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadEntry(), validationEnabled);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,WorkloadEntry instance) {
    this(fluent, instance, false);
  }
  public WorkloadEntryBuilder(WorkloadEntryFluent<?> fluent,WorkloadEntry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WorkloadEntry());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadEntryBuilder(WorkloadEntry instance) {
    this(instance,false);
  }
  public WorkloadEntryBuilder(WorkloadEntry instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WorkloadEntry());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkloadEntryFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadEntry build() {
    WorkloadEntry buildable = new WorkloadEntry(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}