package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VirtualServiceSpecFluent<A extends VirtualServiceSpecFluent<A>> extends BaseFluent<A>{
  public VirtualServiceSpecFluent() {
  }
  public VirtualServiceSpecFluent(VirtualServiceSpec instance) {
    instance = (instance != null ? instance : new VirtualServiceSpec());

    if (instance != null) {
      this.withExportTo(instance.getExportTo());
      this.withGateways(instance.getGateways());
      this.withHosts(instance.getHosts());
      this.withHttp(instance.getHttp());
      this.withTcp(instance.getTcp());
      this.withTls(instance.getTls());
      this.withExportTo(instance.getExportTo());
      this.withGateways(instance.getGateways());
      this.withHosts(instance.getHosts());
      this.withHttp(instance.getHttp());
      this.withTcp(instance.getTcp());
      this.withTls(instance.getTls());
    }
  }
  private List<String> exportTo = new ArrayList<String>();
  private List<String> gateways = new ArrayList<String>();
  private List<String> hosts = new ArrayList<String>();
  private ArrayList<HTTPRouteBuilder> http = new ArrayList<HTTPRouteBuilder>();
  private ArrayList<TCPRouteBuilder> tcp = new ArrayList<TCPRouteBuilder>();
  private ArrayList<TLSRouteBuilder> tls = new ArrayList<TLSRouteBuilder>();
  public A addToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.add(index, item);
    return (A)this;
  }
  public A setToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.set(index, item); return (A)this;
  }
  public A addToExportTo(java.lang.String... items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A addAllToExportTo(Collection<String> items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A removeFromExportTo(java.lang.String... items) {
    if (this.exportTo == null) return (A)this;
    for (String item : items) { this.exportTo.remove(item);} return (A)this;
  }
  public A removeAllFromExportTo(Collection<String> items) {
    if (this.exportTo == null) return (A)this;
    for (String item : items) { this.exportTo.remove(item);} return (A)this;
  }
  public List<String> getExportTo() {
    return this.exportTo;
  }
  public String getExportTo(int index) {
    return this.exportTo.get(index);
  }
  public String getFirstExportTo() {
    return this.exportTo.get(0);
  }
  public String getLastExportTo() {
    return this.exportTo.get(exportTo.size() - 1);
  }
  public String getMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExportTo(List<String> exportTo) {
    if (exportTo != null) {this.exportTo = new ArrayList(); for (String item : exportTo){this.addToExportTo(item);}} else { this.exportTo = null;} return (A) this;
  }
  public A withExportTo(java.lang.String... exportTo) {
    if (this.exportTo != null) {this.exportTo.clear(); _visitables.remove("exportTo"); }
    if (exportTo != null) {for (String item :exportTo){ this.addToExportTo(item);}} return (A) this;
  }
  public boolean hasExportTo() {
    return exportTo != null && !exportTo.isEmpty();
  }
  public A addToGateways(int index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.add(index, item);
    return (A)this;
  }
  public A setToGateways(int index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.set(index, item); return (A)this;
  }
  public A addToGateways(java.lang.String... items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A addAllToGateways(Collection<String> items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A removeFromGateways(java.lang.String... items) {
    if (this.gateways == null) return (A)this;
    for (String item : items) { this.gateways.remove(item);} return (A)this;
  }
  public A removeAllFromGateways(Collection<String> items) {
    if (this.gateways == null) return (A)this;
    for (String item : items) { this.gateways.remove(item);} return (A)this;
  }
  public List<String> getGateways() {
    return this.gateways;
  }
  public String getGateway(int index) {
    return this.gateways.get(index);
  }
  public String getFirstGateway() {
    return this.gateways.get(0);
  }
  public String getLastGateway() {
    return this.gateways.get(gateways.size() - 1);
  }
  public String getMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGateways(List<String> gateways) {
    if (gateways != null) {this.gateways = new ArrayList(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
  }
  public A withGateways(java.lang.String... gateways) {
    if (this.gateways != null) {this.gateways.clear(); _visitables.remove("gateways"); }
    if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
  }
  public boolean hasGateways() {
    return gateways != null && !gateways.isEmpty();
  }
  public A addToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  public A setToHosts(int index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.set(index, item); return (A)this;
  }
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A addAllToHosts(Collection<String> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A removeFromHosts(java.lang.String... items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  public A removeAllFromHosts(Collection<String> items) {
    if (this.hosts == null) return (A)this;
    for (String item : items) { this.hosts.remove(item);} return (A)this;
  }
  public List<String> getHosts() {
    return this.hosts;
  }
  public String getHost(int index) {
    return this.hosts.get(index);
  }
  public String getFirstHost() {
    return this.hosts.get(0);
  }
  public String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  public String getMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(List<String> hosts) {
    if (hosts != null) {this.hosts = new ArrayList(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {this.hosts.clear(); _visitables.remove("hosts"); }
    if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  public A addToHttp(int index,HTTPRoute item) {
    if (this.http == null) {this.http = new ArrayList<HTTPRouteBuilder>();}
    HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
    if (index < 0 || index >= http.size()) { _visitables.get("http").add(builder); http.add(builder); } else { _visitables.get("http").add(index, builder); http.add(index, builder);}
    return (A)this;
  }
  public A setToHttp(int index,HTTPRoute item) {
    if (this.http == null) {this.http = new ArrayList<HTTPRouteBuilder>();}
    HTTPRouteBuilder builder = new HTTPRouteBuilder(item);
    if (index < 0 || index >= http.size()) { _visitables.get("http").add(builder); http.add(builder); } else { _visitables.get("http").set(index, builder); http.set(index, builder);}
    return (A)this;
  }
  public A addToHttp(io.fabric8.istio.api.networking.v1alpha3.HTTPRoute... items) {
    if (this.http == null) {this.http = new ArrayList<HTTPRouteBuilder>();}
    for (HTTPRoute item : items) {HTTPRouteBuilder builder = new HTTPRouteBuilder(item);_visitables.get("http").add(builder);this.http.add(builder);} return (A)this;
  }
  public A addAllToHttp(Collection<HTTPRoute> items) {
    if (this.http == null) {this.http = new ArrayList<HTTPRouteBuilder>();}
    for (HTTPRoute item : items) {HTTPRouteBuilder builder = new HTTPRouteBuilder(item);_visitables.get("http").add(builder);this.http.add(builder);} return (A)this;
  }
  public A removeFromHttp(io.fabric8.istio.api.networking.v1alpha3.HTTPRoute... items) {
    if (this.http == null) return (A)this;
    for (HTTPRoute item : items) {HTTPRouteBuilder builder = new HTTPRouteBuilder(item);_visitables.get("http").remove(builder); this.http.remove(builder);} return (A)this;
  }
  public A removeAllFromHttp(Collection<HTTPRoute> items) {
    if (this.http == null) return (A)this;
    for (HTTPRoute item : items) {HTTPRouteBuilder builder = new HTTPRouteBuilder(item);_visitables.get("http").remove(builder); this.http.remove(builder);} return (A)this;
  }
  public A removeMatchingFromHttp(Predicate<HTTPRouteBuilder> predicate) {
    if (http == null) return (A) this;
    final Iterator<HTTPRouteBuilder> each = http.iterator();
    final List visitables = _visitables.get("http");
    while (each.hasNext()) {
      HTTPRouteBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<HTTPRoute> buildHttp() {
    return http != null ? build(http) : null;
  }
  public HTTPRoute buildHttp(int index) {
    return this.http.get(index).build();
  }
  public HTTPRoute buildFirstHttp() {
    return this.http.get(0).build();
  }
  public HTTPRoute buildLastHttp() {
    return this.http.get(http.size() - 1).build();
  }
  public HTTPRoute buildMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
    for (HTTPRouteBuilder item: http) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
    for (HTTPRouteBuilder item: http) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHttp(List<HTTPRoute> http) {
    if (this.http != null) { _visitables.get("http").clear();}
    if (http != null) {this.http = new ArrayList(); for (HTTPRoute item : http){this.addToHttp(item);}} else { this.http = null;} return (A) this;
  }
  public A withHttp(io.fabric8.istio.api.networking.v1alpha3.HTTPRoute... http) {
    if (this.http != null) {this.http.clear(); _visitables.remove("http"); }
    if (http != null) {for (HTTPRoute item :http){ this.addToHttp(item);}} return (A) this;
  }
  public boolean hasHttp() {
    return http != null && !http.isEmpty();
  }
  public HttpNested<A> addNewHttp() {
    return new HttpNested(-1, null);
  }
  public HttpNested<A> addNewHttpLike(HTTPRoute item) {
    return new HttpNested(-1, item);
  }
  public HttpNested<A> setNewHttpLike(int index,HTTPRoute item) {
    return new HttpNested(index, item);
  }
  public HttpNested<A> editHttp(int index) {
    if (http.size() <= index) throw new RuntimeException("Can't edit http. Index exceeds size.");
    return setNewHttpLike(index, buildHttp(index));
  }
  public HttpNested<A> editFirstHttp() {
    if (http.size() == 0) throw new RuntimeException("Can't edit first http. The list is empty.");
    return setNewHttpLike(0, buildHttp(0));
  }
  public HttpNested<A> editLastHttp() {
    int index = http.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last http. The list is empty.");
    return setNewHttpLike(index, buildHttp(index));
  }
  public HttpNested<A> editMatchingHttp(Predicate<HTTPRouteBuilder> predicate) {
    int index = -1;
    for (int i=0;i<http.size();i++) { 
    if (predicate.test(http.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching http. No match found.");
    return setNewHttpLike(index, buildHttp(index));
  }
  public A addToTcp(int index,TCPRoute item) {
    if (this.tcp == null) {this.tcp = new ArrayList<TCPRouteBuilder>();}
    TCPRouteBuilder builder = new TCPRouteBuilder(item);
    if (index < 0 || index >= tcp.size()) { _visitables.get("tcp").add(builder); tcp.add(builder); } else { _visitables.get("tcp").add(index, builder); tcp.add(index, builder);}
    return (A)this;
  }
  public A setToTcp(int index,TCPRoute item) {
    if (this.tcp == null) {this.tcp = new ArrayList<TCPRouteBuilder>();}
    TCPRouteBuilder builder = new TCPRouteBuilder(item);
    if (index < 0 || index >= tcp.size()) { _visitables.get("tcp").add(builder); tcp.add(builder); } else { _visitables.get("tcp").set(index, builder); tcp.set(index, builder);}
    return (A)this;
  }
  public A addToTcp(io.fabric8.istio.api.networking.v1alpha3.TCPRoute... items) {
    if (this.tcp == null) {this.tcp = new ArrayList<TCPRouteBuilder>();}
    for (TCPRoute item : items) {TCPRouteBuilder builder = new TCPRouteBuilder(item);_visitables.get("tcp").add(builder);this.tcp.add(builder);} return (A)this;
  }
  public A addAllToTcp(Collection<TCPRoute> items) {
    if (this.tcp == null) {this.tcp = new ArrayList<TCPRouteBuilder>();}
    for (TCPRoute item : items) {TCPRouteBuilder builder = new TCPRouteBuilder(item);_visitables.get("tcp").add(builder);this.tcp.add(builder);} return (A)this;
  }
  public A removeFromTcp(io.fabric8.istio.api.networking.v1alpha3.TCPRoute... items) {
    if (this.tcp == null) return (A)this;
    for (TCPRoute item : items) {TCPRouteBuilder builder = new TCPRouteBuilder(item);_visitables.get("tcp").remove(builder); this.tcp.remove(builder);} return (A)this;
  }
  public A removeAllFromTcp(Collection<TCPRoute> items) {
    if (this.tcp == null) return (A)this;
    for (TCPRoute item : items) {TCPRouteBuilder builder = new TCPRouteBuilder(item);_visitables.get("tcp").remove(builder); this.tcp.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTcp(Predicate<TCPRouteBuilder> predicate) {
    if (tcp == null) return (A) this;
    final Iterator<TCPRouteBuilder> each = tcp.iterator();
    final List visitables = _visitables.get("tcp");
    while (each.hasNext()) {
      TCPRouteBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<TCPRoute> buildTcp() {
    return tcp != null ? build(tcp) : null;
  }
  public TCPRoute buildTcp(int index) {
    return this.tcp.get(index).build();
  }
  public TCPRoute buildFirstTcp() {
    return this.tcp.get(0).build();
  }
  public TCPRoute buildLastTcp() {
    return this.tcp.get(tcp.size() - 1).build();
  }
  public TCPRoute buildMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
    for (TCPRouteBuilder item: tcp) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
    for (TCPRouteBuilder item: tcp) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTcp(List<TCPRoute> tcp) {
    if (this.tcp != null) { _visitables.get("tcp").clear();}
    if (tcp != null) {this.tcp = new ArrayList(); for (TCPRoute item : tcp){this.addToTcp(item);}} else { this.tcp = null;} return (A) this;
  }
  public A withTcp(io.fabric8.istio.api.networking.v1alpha3.TCPRoute... tcp) {
    if (this.tcp != null) {this.tcp.clear(); _visitables.remove("tcp"); }
    if (tcp != null) {for (TCPRoute item :tcp){ this.addToTcp(item);}} return (A) this;
  }
  public boolean hasTcp() {
    return tcp != null && !tcp.isEmpty();
  }
  public TcpNested<A> addNewTcp() {
    return new TcpNested(-1, null);
  }
  public TcpNested<A> addNewTcpLike(TCPRoute item) {
    return new TcpNested(-1, item);
  }
  public TcpNested<A> setNewTcpLike(int index,TCPRoute item) {
    return new TcpNested(index, item);
  }
  public TcpNested<A> editTcp(int index) {
    if (tcp.size() <= index) throw new RuntimeException("Can't edit tcp. Index exceeds size.");
    return setNewTcpLike(index, buildTcp(index));
  }
  public TcpNested<A> editFirstTcp() {
    if (tcp.size() == 0) throw new RuntimeException("Can't edit first tcp. The list is empty.");
    return setNewTcpLike(0, buildTcp(0));
  }
  public TcpNested<A> editLastTcp() {
    int index = tcp.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tcp. The list is empty.");
    return setNewTcpLike(index, buildTcp(index));
  }
  public TcpNested<A> editMatchingTcp(Predicate<TCPRouteBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tcp.size();i++) { 
    if (predicate.test(tcp.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tcp. No match found.");
    return setNewTcpLike(index, buildTcp(index));
  }
  public A addToTls(int index,TLSRoute item) {
    if (this.tls == null) {this.tls = new ArrayList<TLSRouteBuilder>();}
    TLSRouteBuilder builder = new TLSRouteBuilder(item);
    if (index < 0 || index >= tls.size()) { _visitables.get("tls").add(builder); tls.add(builder); } else { _visitables.get("tls").add(index, builder); tls.add(index, builder);}
    return (A)this;
  }
  public A setToTls(int index,TLSRoute item) {
    if (this.tls == null) {this.tls = new ArrayList<TLSRouteBuilder>();}
    TLSRouteBuilder builder = new TLSRouteBuilder(item);
    if (index < 0 || index >= tls.size()) { _visitables.get("tls").add(builder); tls.add(builder); } else { _visitables.get("tls").set(index, builder); tls.set(index, builder);}
    return (A)this;
  }
  public A addToTls(io.fabric8.istio.api.networking.v1alpha3.TLSRoute... items) {
    if (this.tls == null) {this.tls = new ArrayList<TLSRouteBuilder>();}
    for (TLSRoute item : items) {TLSRouteBuilder builder = new TLSRouteBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
  }
  public A addAllToTls(Collection<TLSRoute> items) {
    if (this.tls == null) {this.tls = new ArrayList<TLSRouteBuilder>();}
    for (TLSRoute item : items) {TLSRouteBuilder builder = new TLSRouteBuilder(item);_visitables.get("tls").add(builder);this.tls.add(builder);} return (A)this;
  }
  public A removeFromTls(io.fabric8.istio.api.networking.v1alpha3.TLSRoute... items) {
    if (this.tls == null) return (A)this;
    for (TLSRoute item : items) {TLSRouteBuilder builder = new TLSRouteBuilder(item);_visitables.get("tls").remove(builder); this.tls.remove(builder);} return (A)this;
  }
  public A removeAllFromTls(Collection<TLSRoute> items) {
    if (this.tls == null) return (A)this;
    for (TLSRoute item : items) {TLSRouteBuilder builder = new TLSRouteBuilder(item);_visitables.get("tls").remove(builder); this.tls.remove(builder);} return (A)this;
  }
  public A removeMatchingFromTls(Predicate<TLSRouteBuilder> predicate) {
    if (tls == null) return (A) this;
    final Iterator<TLSRouteBuilder> each = tls.iterator();
    final List visitables = _visitables.get("tls");
    while (each.hasNext()) {
      TLSRouteBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<TLSRoute> buildTls() {
    return tls != null ? build(tls) : null;
  }
  public TLSRoute buildTl(int index) {
    return this.tls.get(index).build();
  }
  public TLSRoute buildFirstTl() {
    return this.tls.get(0).build();
  }
  public TLSRoute buildLastTl() {
    return this.tls.get(tls.size() - 1).build();
  }
  public TLSRoute buildMatchingTl(Predicate<TLSRouteBuilder> predicate) {
    for (TLSRouteBuilder item: tls) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingTl(Predicate<TLSRouteBuilder> predicate) {
    for (TLSRouteBuilder item: tls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTls(List<TLSRoute> tls) {
    if (this.tls != null) { _visitables.get("tls").clear();}
    if (tls != null) {this.tls = new ArrayList(); for (TLSRoute item : tls){this.addToTls(item);}} else { this.tls = null;} return (A) this;
  }
  public A withTls(io.fabric8.istio.api.networking.v1alpha3.TLSRoute... tls) {
    if (this.tls != null) {this.tls.clear(); _visitables.remove("tls"); }
    if (tls != null) {for (TLSRoute item :tls){ this.addToTls(item);}} return (A) this;
  }
  public boolean hasTls() {
    return tls != null && !tls.isEmpty();
  }
  public TlsNested<A> addNewTl() {
    return new TlsNested(-1, null);
  }
  public TlsNested<A> addNewTlLike(TLSRoute item) {
    return new TlsNested(-1, item);
  }
  public TlsNested<A> setNewTlLike(int index,TLSRoute item) {
    return new TlsNested(index, item);
  }
  public TlsNested<A> editTl(int index) {
    if (tls.size() <= index) throw new RuntimeException("Can't edit tls. Index exceeds size.");
    return setNewTlLike(index, buildTl(index));
  }
  public TlsNested<A> editFirstTl() {
    if (tls.size() == 0) throw new RuntimeException("Can't edit first tls. The list is empty.");
    return setNewTlLike(0, buildTl(0));
  }
  public TlsNested<A> editLastTl() {
    int index = tls.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last tls. The list is empty.");
    return setNewTlLike(index, buildTl(index));
  }
  public TlsNested<A> editMatchingTl(Predicate<TLSRouteBuilder> predicate) {
    int index = -1;
    for (int i=0;i<tls.size();i++) { 
    if (predicate.test(tls.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching tls. No match found.");
    return setNewTlLike(index, buildTl(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VirtualServiceSpecFluent that = (VirtualServiceSpecFluent) o;
    if (!java.util.Objects.equals(exportTo, that.exportTo)) return false;

    if (!java.util.Objects.equals(gateways, that.gateways)) return false;

    if (!java.util.Objects.equals(hosts, that.hosts)) return false;

    if (!java.util.Objects.equals(http, that.http)) return false;

    if (!java.util.Objects.equals(tcp, that.tcp)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(exportTo,  gateways,  hosts,  http,  tcp,  tls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (exportTo != null && !exportTo.isEmpty()) { sb.append("exportTo:"); sb.append(exportTo + ","); }
    if (gateways != null && !gateways.isEmpty()) { sb.append("gateways:"); sb.append(gateways + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (http != null && !http.isEmpty()) { sb.append("http:"); sb.append(http + ","); }
    if (tcp != null && !tcp.isEmpty()) { sb.append("tcp:"); sb.append(tcp + ","); }
    if (tls != null && !tls.isEmpty()) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  public class HttpNested<N> extends HTTPRouteFluent<HttpNested<N>> implements Nested<N>{
    HttpNested(int index,HTTPRoute item) {
      this.index = index;
      this.builder = new HTTPRouteBuilder(this, item);
    }
    HTTPRouteBuilder builder;
    int index;
    public N and() {
      return (N) VirtualServiceSpecFluent.this.setToHttp(index,builder.build());
    }
    public N endHttp() {
      return and();
    }
    
  }
  public class TcpNested<N> extends TCPRouteFluent<TcpNested<N>> implements Nested<N>{
    TcpNested(int index,TCPRoute item) {
      this.index = index;
      this.builder = new TCPRouteBuilder(this, item);
    }
    TCPRouteBuilder builder;
    int index;
    public N and() {
      return (N) VirtualServiceSpecFluent.this.setToTcp(index,builder.build());
    }
    public N endTcp() {
      return and();
    }
    
  }
  public class TlsNested<N> extends TLSRouteFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(int index,TLSRoute item) {
      this.index = index;
      this.builder = new TLSRouteBuilder(this, item);
    }
    TLSRouteBuilder builder;
    int index;
    public N and() {
      return (N) VirtualServiceSpecFluent.this.setToTls(index,builder.build());
    }
    public N endTl() {
      return and();
    }
    
  }
  
}