package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TLSRouteFluent<A extends TLSRouteFluent<A>> extends BaseFluent<A>{
  public TLSRouteFluent() {
  }
  public TLSRouteFluent(TLSRoute instance) {
    instance = (instance != null ? instance : new TLSRoute());

    if (instance != null) {
      this.withMatch(instance.getMatch());
      this.withRoute(instance.getRoute());
      this.withMatch(instance.getMatch());
      this.withRoute(instance.getRoute());
    }
  }
  private ArrayList<TLSMatchAttributesBuilder> match = new ArrayList<TLSMatchAttributesBuilder>();
  private ArrayList<RouteDestinationBuilder> route = new ArrayList<RouteDestinationBuilder>();
  public A addToMatch(int index,TLSMatchAttributes item) {
    if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
    TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").add(index, builder); match.add(index, builder);}
    return (A)this;
  }
  public A setToMatch(int index,TLSMatchAttributes item) {
    if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
    TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").set(index, builder); match.set(index, builder);}
    return (A)this;
  }
  public A addToMatch(io.fabric8.istio.api.networking.v1alpha3.TLSMatchAttributes... items) {
    if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
    for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A addAllToMatch(Collection<TLSMatchAttributes> items) {
    if (this.match == null) {this.match = new ArrayList<TLSMatchAttributesBuilder>();}
    for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A removeFromMatch(io.fabric8.istio.api.networking.v1alpha3.TLSMatchAttributes... items) {
    if (this.match == null) return (A)this;
    for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.get("match").remove(builder); this.match.remove(builder);} return (A)this;
  }
  public A removeAllFromMatch(Collection<TLSMatchAttributes> items) {
    if (this.match == null) return (A)this;
    for (TLSMatchAttributes item : items) {TLSMatchAttributesBuilder builder = new TLSMatchAttributesBuilder(item);_visitables.get("match").remove(builder); this.match.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMatch(Predicate<TLSMatchAttributesBuilder> predicate) {
    if (match == null) return (A) this;
    final Iterator<TLSMatchAttributesBuilder> each = match.iterator();
    final List visitables = _visitables.get("match");
    while (each.hasNext()) {
      TLSMatchAttributesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<TLSMatchAttributes> buildMatch() {
    return match != null ? build(match) : null;
  }
  public TLSMatchAttributes buildMatch(int index) {
    return this.match.get(index).build();
  }
  public TLSMatchAttributes buildFirstMatch() {
    return this.match.get(0).build();
  }
  public TLSMatchAttributes buildLastMatch() {
    return this.match.get(match.size() - 1).build();
  }
  public TLSMatchAttributes buildMatchingMatch(Predicate<TLSMatchAttributesBuilder> predicate) {
    for (TLSMatchAttributesBuilder item: match) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMatch(Predicate<TLSMatchAttributesBuilder> predicate) {
    for (TLSMatchAttributesBuilder item: match) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatch(List<TLSMatchAttributes> match) {
    if (this.match != null) { _visitables.get("match").clear();}
    if (match != null) {this.match = new ArrayList(); for (TLSMatchAttributes item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
  }
  public A withMatch(io.fabric8.istio.api.networking.v1alpha3.TLSMatchAttributes... match) {
    if (this.match != null) {this.match.clear(); _visitables.remove("match"); }
    if (match != null) {for (TLSMatchAttributes item :match){ this.addToMatch(item);}} return (A) this;
  }
  public boolean hasMatch() {
    return match != null && !match.isEmpty();
  }
  public MatchNested<A> addNewMatch() {
    return new MatchNested(-1, null);
  }
  public MatchNested<A> addNewMatchLike(TLSMatchAttributes item) {
    return new MatchNested(-1, item);
  }
  public MatchNested<A> setNewMatchLike(int index,TLSMatchAttributes item) {
    return new MatchNested(index, item);
  }
  public MatchNested<A> editMatch(int index) {
    if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public MatchNested<A> editFirstMatch() {
    if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  public MatchNested<A> editLastMatch() {
    int index = match.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public MatchNested<A> editMatchingMatch(Predicate<TLSMatchAttributesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<match.size();i++) { 
    if (predicate.test(match.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public A addToRoute(int index,RouteDestination item) {
    if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
    RouteDestinationBuilder builder = new RouteDestinationBuilder(item);
    if (index < 0 || index >= route.size()) { _visitables.get("route").add(builder); route.add(builder); } else { _visitables.get("route").add(index, builder); route.add(index, builder);}
    return (A)this;
  }
  public A setToRoute(int index,RouteDestination item) {
    if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
    RouteDestinationBuilder builder = new RouteDestinationBuilder(item);
    if (index < 0 || index >= route.size()) { _visitables.get("route").add(builder); route.add(builder); } else { _visitables.get("route").set(index, builder); route.set(index, builder);}
    return (A)this;
  }
  public A addToRoute(io.fabric8.istio.api.networking.v1alpha3.RouteDestination... items) {
    if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
    for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
  }
  public A addAllToRoute(Collection<RouteDestination> items) {
    if (this.route == null) {this.route = new ArrayList<RouteDestinationBuilder>();}
    for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
  }
  public A removeFromRoute(io.fabric8.istio.api.networking.v1alpha3.RouteDestination... items) {
    if (this.route == null) return (A)this;
    for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").remove(builder); this.route.remove(builder);} return (A)this;
  }
  public A removeAllFromRoute(Collection<RouteDestination> items) {
    if (this.route == null) return (A)this;
    for (RouteDestination item : items) {RouteDestinationBuilder builder = new RouteDestinationBuilder(item);_visitables.get("route").remove(builder); this.route.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRoute(Predicate<RouteDestinationBuilder> predicate) {
    if (route == null) return (A) this;
    final Iterator<RouteDestinationBuilder> each = route.iterator();
    final List visitables = _visitables.get("route");
    while (each.hasNext()) {
      RouteDestinationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<RouteDestination> buildRoute() {
    return route != null ? build(route) : null;
  }
  public RouteDestination buildRoute(int index) {
    return this.route.get(index).build();
  }
  public RouteDestination buildFirstRoute() {
    return this.route.get(0).build();
  }
  public RouteDestination buildLastRoute() {
    return this.route.get(route.size() - 1).build();
  }
  public RouteDestination buildMatchingRoute(Predicate<RouteDestinationBuilder> predicate) {
    for (RouteDestinationBuilder item: route) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRoute(Predicate<RouteDestinationBuilder> predicate) {
    for (RouteDestinationBuilder item: route) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoute(List<RouteDestination> route) {
    if (this.route != null) { _visitables.get("route").clear();}
    if (route != null) {this.route = new ArrayList(); for (RouteDestination item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
  }
  public A withRoute(io.fabric8.istio.api.networking.v1alpha3.RouteDestination... route) {
    if (this.route != null) {this.route.clear(); _visitables.remove("route"); }
    if (route != null) {for (RouteDestination item :route){ this.addToRoute(item);}} return (A) this;
  }
  public boolean hasRoute() {
    return route != null && !route.isEmpty();
  }
  public RouteNested<A> addNewRoute() {
    return new RouteNested(-1, null);
  }
  public RouteNested<A> addNewRouteLike(RouteDestination item) {
    return new RouteNested(-1, item);
  }
  public RouteNested<A> setNewRouteLike(int index,RouteDestination item) {
    return new RouteNested(index, item);
  }
  public RouteNested<A> editRoute(int index) {
    if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public RouteNested<A> editFirstRoute() {
    if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  public RouteNested<A> editLastRoute() {
    int index = route.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public RouteNested<A> editMatchingRoute(Predicate<RouteDestinationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<route.size();i++) { 
    if (predicate.test(route.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TLSRouteFluent that = (TLSRouteFluent) o;
    if (!java.util.Objects.equals(match, that.match)) return false;

    if (!java.util.Objects.equals(route, that.route)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(match,  route,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (match != null && !match.isEmpty()) { sb.append("match:"); sb.append(match + ","); }
    if (route != null && !route.isEmpty()) { sb.append("route:"); sb.append(route); }
    sb.append("}");
    return sb.toString();
  }
  public class MatchNested<N> extends TLSMatchAttributesFluent<MatchNested<N>> implements Nested<N>{
    MatchNested(int index,TLSMatchAttributes item) {
      this.index = index;
      this.builder = new TLSMatchAttributesBuilder(this, item);
    }
    TLSMatchAttributesBuilder builder;
    int index;
    public N and() {
      return (N) TLSRouteFluent.this.setToMatch(index,builder.build());
    }
    public N endMatch() {
      return and();
    }
    
  }
  public class RouteNested<N> extends RouteDestinationFluent<RouteNested<N>> implements Nested<N>{
    RouteNested(int index,RouteDestination item) {
      this.index = index;
      this.builder = new RouteDestinationBuilder(this, item);
    }
    RouteDestinationBuilder builder;
    int index;
    public N and() {
      return (N) TLSRouteFluent.this.setToRoute(index,builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  
}