package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSRouteBuilder extends TLSRouteFluent<TLSRouteBuilder> implements VisitableBuilder<TLSRoute,TLSRouteBuilder>{
  public TLSRouteBuilder() {
    this(false);
  }
  public TLSRouteBuilder(Boolean validationEnabled) {
    this(new TLSRoute(), validationEnabled);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSRoute(), validationEnabled);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance) {
    this(fluent, instance, false);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TLSRoute());

    if (instance != null) {
      fluent.withMatch(instance.getMatch());
      fluent.withRoute(instance.getRoute());
      fluent.withMatch(instance.getMatch());
      fluent.withRoute(instance.getRoute());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TLSRouteBuilder(TLSRoute instance) {
    this(instance,false);
  }
  public TLSRouteBuilder(TLSRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TLSRoute());

    if (instance != null) {
      this.withMatch(instance.getMatch());
      this.withRoute(instance.getRoute());
      this.withMatch(instance.getMatch());
      this.withRoute(instance.getRoute());
    }
    this.validationEnabled = validationEnabled; 
  }
  TLSRouteFluent<?> fluent;
  Boolean validationEnabled;
  public TLSRoute build() {
    TLSRoute buildable = new TLSRoute(fluent.buildMatch(),fluent.buildRoute());
    return buildable;
  }
  
}