package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StringMatchRegexBuilder extends StringMatchRegexFluent<StringMatchRegexBuilder> implements VisitableBuilder<StringMatchRegex,StringMatchRegexBuilder>{
  public StringMatchRegexBuilder() {
    this(false);
  }
  public StringMatchRegexBuilder(Boolean validationEnabled) {
    this(new StringMatchRegex(), validationEnabled);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent) {
    this(fluent, false);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StringMatchRegex(), validationEnabled);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent,StringMatchRegex instance) {
    this(fluent, instance, false);
  }
  public StringMatchRegexBuilder(StringMatchRegexFluent<?> fluent,StringMatchRegex instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StringMatchRegex());

    if (instance != null) {
      fluent.withRegex(instance.getRegex());
      fluent.withRegex(instance.getRegex());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StringMatchRegexBuilder(StringMatchRegex instance) {
    this(instance,false);
  }
  public StringMatchRegexBuilder(StringMatchRegex instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StringMatchRegex());

    if (instance != null) {
      this.withRegex(instance.getRegex());
      this.withRegex(instance.getRegex());
    }
    this.validationEnabled = validationEnabled; 
  }
  StringMatchRegexFluent<?> fluent;
  Boolean validationEnabled;
  public StringMatchRegex build() {
    StringMatchRegex buildable = new StringMatchRegex(fluent.getRegex());
    return buildable;
  }
  
}