package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StringMatchPrefixBuilder extends StringMatchPrefixFluent<StringMatchPrefixBuilder> implements VisitableBuilder<StringMatchPrefix,StringMatchPrefixBuilder>{
  public StringMatchPrefixBuilder() {
    this(false);
  }
  public StringMatchPrefixBuilder(Boolean validationEnabled) {
    this(new StringMatchPrefix(), validationEnabled);
  }
  public StringMatchPrefixBuilder(StringMatchPrefixFluent<?> fluent) {
    this(fluent, false);
  }
  public StringMatchPrefixBuilder(StringMatchPrefixFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StringMatchPrefix(), validationEnabled);
  }
  public StringMatchPrefixBuilder(StringMatchPrefixFluent<?> fluent,StringMatchPrefix instance) {
    this(fluent, instance, false);
  }
  public StringMatchPrefixBuilder(StringMatchPrefixFluent<?> fluent,StringMatchPrefix instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StringMatchPrefix());

    if (instance != null) {
      fluent.withPrefix(instance.getPrefix());
      fluent.withPrefix(instance.getPrefix());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StringMatchPrefixBuilder(StringMatchPrefix instance) {
    this(instance,false);
  }
  public StringMatchPrefixBuilder(StringMatchPrefix instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StringMatchPrefix());

    if (instance != null) {
      this.withPrefix(instance.getPrefix());
      this.withPrefix(instance.getPrefix());
    }
    this.validationEnabled = validationEnabled; 
  }
  StringMatchPrefixFluent<?> fluent;
  Boolean validationEnabled;
  public StringMatchPrefix build() {
    StringMatchPrefix buildable = new StringMatchPrefix(fluent.getPrefix());
    return buildable;
  }
  
}