package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceEntryBuilder extends ServiceEntryFluent<ServiceEntryBuilder> implements VisitableBuilder<ServiceEntry,ServiceEntryBuilder>{
  public ServiceEntryBuilder() {
    this(false);
  }
  public ServiceEntryBuilder(Boolean validationEnabled) {
    this(new ServiceEntry(), validationEnabled);
  }
  public ServiceEntryBuilder(ServiceEntryFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceEntryBuilder(ServiceEntryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceEntry(), validationEnabled);
  }
  public ServiceEntryBuilder(ServiceEntryFluent<?> fluent,ServiceEntry instance) {
    this(fluent, instance, false);
  }
  public ServiceEntryBuilder(ServiceEntryFluent<?> fluent,ServiceEntry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceEntry());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceEntryBuilder(ServiceEntry instance) {
    this(instance,false);
  }
  public ServiceEntryBuilder(ServiceEntry instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceEntry());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceEntryFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceEntry build() {
    ServiceEntry buildable = new ServiceEntry(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}