package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReadinessProbeExecBuilder extends ReadinessProbeExecFluent<ReadinessProbeExecBuilder> implements VisitableBuilder<ReadinessProbeExec,ReadinessProbeExecBuilder>{
  public ReadinessProbeExecBuilder() {
    this(false);
  }
  public ReadinessProbeExecBuilder(Boolean validationEnabled) {
    this(new ReadinessProbeExec(), validationEnabled);
  }
  public ReadinessProbeExecBuilder(ReadinessProbeExecFluent<?> fluent) {
    this(fluent, false);
  }
  public ReadinessProbeExecBuilder(ReadinessProbeExecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReadinessProbeExec(), validationEnabled);
  }
  public ReadinessProbeExecBuilder(ReadinessProbeExecFluent<?> fluent,ReadinessProbeExec instance) {
    this(fluent, instance, false);
  }
  public ReadinessProbeExecBuilder(ReadinessProbeExecFluent<?> fluent,ReadinessProbeExec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReadinessProbeExec());

    if (instance != null) {
      fluent.withExec(instance.getExec());
      fluent.withExec(instance.getExec());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReadinessProbeExecBuilder(ReadinessProbeExec instance) {
    this(instance,false);
  }
  public ReadinessProbeExecBuilder(ReadinessProbeExec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReadinessProbeExec());

    if (instance != null) {
      this.withExec(instance.getExec());
      this.withExec(instance.getExec());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReadinessProbeExecFluent<?> fluent;
  Boolean validationEnabled;
  public ReadinessProbeExec build() {
    ReadinessProbeExec buildable = new ReadinessProbeExec(fluent.buildExec());
    return buildable;
  }
  
}