package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OutboundTrafficPolicyBuilder extends OutboundTrafficPolicyFluent<OutboundTrafficPolicyBuilder> implements VisitableBuilder<OutboundTrafficPolicy,OutboundTrafficPolicyBuilder>{
  public OutboundTrafficPolicyBuilder() {
    this(false);
  }
  public OutboundTrafficPolicyBuilder(Boolean validationEnabled) {
    this(new OutboundTrafficPolicy(), validationEnabled);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OutboundTrafficPolicy(), validationEnabled);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance) {
    this(fluent, instance, false);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OutboundTrafficPolicy());

    if (instance != null) {
      fluent.withEgressProxy(instance.getEgressProxy());
      fluent.withMode(instance.getMode());
      fluent.withEgressProxy(instance.getEgressProxy());
      fluent.withMode(instance.getMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance) {
    this(instance,false);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OutboundTrafficPolicy());

    if (instance != null) {
      this.withEgressProxy(instance.getEgressProxy());
      this.withMode(instance.getMode());
      this.withEgressProxy(instance.getEgressProxy());
      this.withMode(instance.getMode());
    }
    this.validationEnabled = validationEnabled; 
  }
  OutboundTrafficPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public OutboundTrafficPolicy build() {
    OutboundTrafficPolicy buildable = new OutboundTrafficPolicy(fluent.buildEgressProxy(),fluent.getMode());
    return buildable;
  }
  
}