package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalityLoadBalancerSettingBuilder extends LocalityLoadBalancerSettingFluent<LocalityLoadBalancerSettingBuilder> implements VisitableBuilder<LocalityLoadBalancerSetting,LocalityLoadBalancerSettingBuilder>{
  public LocalityLoadBalancerSettingBuilder() {
    this(false);
  }
  public LocalityLoadBalancerSettingBuilder(Boolean validationEnabled) {
    this(new LocalityLoadBalancerSetting(), validationEnabled);
  }
  public LocalityLoadBalancerSettingBuilder(LocalityLoadBalancerSettingFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalityLoadBalancerSettingBuilder(LocalityLoadBalancerSettingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LocalityLoadBalancerSetting(), validationEnabled);
  }
  public LocalityLoadBalancerSettingBuilder(LocalityLoadBalancerSettingFluent<?> fluent,LocalityLoadBalancerSetting instance) {
    this(fluent, instance, false);
  }
  public LocalityLoadBalancerSettingBuilder(LocalityLoadBalancerSettingFluent<?> fluent,LocalityLoadBalancerSetting instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LocalityLoadBalancerSetting());

    if (instance != null) {
      fluent.withDistribute(instance.getDistribute());
      fluent.withEnabled(instance.getEnabled());
      fluent.withFailover(instance.getFailover());
      fluent.withFailoverPriority(instance.getFailoverPriority());
      fluent.withDistribute(instance.getDistribute());
      fluent.withEnabled(instance.getEnabled());
      fluent.withFailover(instance.getFailover());
      fluent.withFailoverPriority(instance.getFailoverPriority());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LocalityLoadBalancerSettingBuilder(LocalityLoadBalancerSetting instance) {
    this(instance,false);
  }
  public LocalityLoadBalancerSettingBuilder(LocalityLoadBalancerSetting instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LocalityLoadBalancerSetting());

    if (instance != null) {
      this.withDistribute(instance.getDistribute());
      this.withEnabled(instance.getEnabled());
      this.withFailover(instance.getFailover());
      this.withFailoverPriority(instance.getFailoverPriority());
      this.withDistribute(instance.getDistribute());
      this.withEnabled(instance.getEnabled());
      this.withFailover(instance.getFailover());
      this.withFailoverPriority(instance.getFailoverPriority());
    }
    this.validationEnabled = validationEnabled; 
  }
  LocalityLoadBalancerSettingFluent<?> fluent;
  Boolean validationEnabled;
  public LocalityLoadBalancerSetting build() {
    LocalityLoadBalancerSetting buildable = new LocalityLoadBalancerSetting(fluent.buildDistribute(),fluent.getEnabled(),fluent.buildFailover(),fluent.getFailoverPriority());
    return buildable;
  }
  
}