package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Double;
import java.util.Collection;
import java.lang.Object;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPRouteFluent<A extends HTTPRouteFluent<A>> extends BaseFluent<A>{
  public HTTPRouteFluent() {
  }
  public HTTPRouteFluent(HTTPRoute instance) {
    instance = (instance != null ? instance : new HTTPRoute());

    if (instance != null) {
      this.withCorsPolicy(instance.getCorsPolicy());
      this.withDelegate(instance.getDelegate());
      this.withFault(instance.getFault());
      this.withHeaders(instance.getHeaders());
      this.withMatch(instance.getMatch());
      this.withMirror(instance.getMirror());
      this.withMirrorPercent(instance.getMirrorPercent());
      this.withMirrorPercentage(instance.getMirrorPercentage());
      this.withName(instance.getName());
      this.withRedirect(instance.getRedirect());
      this.withRetries(instance.getRetries());
      this.withRewrite(instance.getRewrite());
      this.withRoute(instance.getRoute());
      this.withTimeout(instance.getTimeout());
      this.withCorsPolicy(instance.getCorsPolicy());
      this.withDelegate(instance.getDelegate());
      this.withFault(instance.getFault());
      this.withHeaders(instance.getHeaders());
      this.withMatch(instance.getMatch());
      this.withMirror(instance.getMirror());
      this.withMirrorPercent(instance.getMirrorPercent());
      this.withMirrorPercentage(instance.getMirrorPercentage());
      this.withName(instance.getName());
      this.withRedirect(instance.getRedirect());
      this.withRetries(instance.getRetries());
      this.withRewrite(instance.getRewrite());
      this.withRoute(instance.getRoute());
      this.withTimeout(instance.getTimeout());
    }
  }
  private CorsPolicyBuilder corsPolicy;
  private DelegateBuilder delegate;
  private HTTPFaultInjectionBuilder fault;
  private HeadersBuilder headers;
  private ArrayList<HTTPMatchRequestBuilder> match = new ArrayList<HTTPMatchRequestBuilder>();
  private DestinationBuilder mirror;
  private Integer mirrorPercent;
  private PercentBuilder mirrorPercentage;
  private String name;
  private HTTPRedirectBuilder redirect;
  private HTTPRetryBuilder retries;
  private HTTPRewriteBuilder rewrite;
  private ArrayList<HTTPRouteDestinationBuilder> route = new ArrayList<HTTPRouteDestinationBuilder>();
  private String timeout;
  public CorsPolicy buildCorsPolicy() {
    return this.corsPolicy!=null ?this.corsPolicy.build():null;
  }
  public A withCorsPolicy(CorsPolicy corsPolicy) {
    _visitables.get("corsPolicy").remove(this.corsPolicy);
    if (corsPolicy!=null){ this.corsPolicy= new CorsPolicyBuilder(corsPolicy); _visitables.get("corsPolicy").add(this.corsPolicy);} else { this.corsPolicy = null; _visitables.get("corsPolicy").remove(this.corsPolicy); } return (A) this;
  }
  public boolean hasCorsPolicy() {
    return this.corsPolicy != null;
  }
  public CorsPolicyNested<A> withNewCorsPolicy() {
    return new CorsPolicyNested(null);
  }
  public CorsPolicyNested<A> withNewCorsPolicyLike(CorsPolicy item) {
    return new CorsPolicyNested(item);
  }
  public CorsPolicyNested<A> editCorsPolicy() {
    return withNewCorsPolicyLike(java.util.Optional.ofNullable(buildCorsPolicy()).orElse(null));
  }
  public CorsPolicyNested<A> editOrNewCorsPolicy() {
    return withNewCorsPolicyLike(java.util.Optional.ofNullable(buildCorsPolicy()).orElse(new CorsPolicyBuilder().build()));
  }
  public CorsPolicyNested<A> editOrNewCorsPolicyLike(CorsPolicy item) {
    return withNewCorsPolicyLike(java.util.Optional.ofNullable(buildCorsPolicy()).orElse(item));
  }
  public Delegate buildDelegate() {
    return this.delegate!=null ?this.delegate.build():null;
  }
  public A withDelegate(Delegate delegate) {
    _visitables.get("delegate").remove(this.delegate);
    if (delegate!=null){ this.delegate= new DelegateBuilder(delegate); _visitables.get("delegate").add(this.delegate);} else { this.delegate = null; _visitables.get("delegate").remove(this.delegate); } return (A) this;
  }
  public boolean hasDelegate() {
    return this.delegate != null;
  }
  public A withNewDelegate(String name,String namespace) {
    return (A)withDelegate(new Delegate(name, namespace));
  }
  public DelegateNested<A> withNewDelegate() {
    return new DelegateNested(null);
  }
  public DelegateNested<A> withNewDelegateLike(Delegate item) {
    return new DelegateNested(item);
  }
  public DelegateNested<A> editDelegate() {
    return withNewDelegateLike(java.util.Optional.ofNullable(buildDelegate()).orElse(null));
  }
  public DelegateNested<A> editOrNewDelegate() {
    return withNewDelegateLike(java.util.Optional.ofNullable(buildDelegate()).orElse(new DelegateBuilder().build()));
  }
  public DelegateNested<A> editOrNewDelegateLike(Delegate item) {
    return withNewDelegateLike(java.util.Optional.ofNullable(buildDelegate()).orElse(item));
  }
  public HTTPFaultInjection buildFault() {
    return this.fault!=null ?this.fault.build():null;
  }
  public A withFault(HTTPFaultInjection fault) {
    _visitables.get("fault").remove(this.fault);
    if (fault!=null){ this.fault= new HTTPFaultInjectionBuilder(fault); _visitables.get("fault").add(this.fault);} else { this.fault = null; _visitables.get("fault").remove(this.fault); } return (A) this;
  }
  public boolean hasFault() {
    return this.fault != null;
  }
  public FaultNested<A> withNewFault() {
    return new FaultNested(null);
  }
  public FaultNested<A> withNewFaultLike(HTTPFaultInjection item) {
    return new FaultNested(item);
  }
  public FaultNested<A> editFault() {
    return withNewFaultLike(java.util.Optional.ofNullable(buildFault()).orElse(null));
  }
  public FaultNested<A> editOrNewFault() {
    return withNewFaultLike(java.util.Optional.ofNullable(buildFault()).orElse(new HTTPFaultInjectionBuilder().build()));
  }
  public FaultNested<A> editOrNewFaultLike(HTTPFaultInjection item) {
    return withNewFaultLike(java.util.Optional.ofNullable(buildFault()).orElse(item));
  }
  public Headers buildHeaders() {
    return this.headers!=null ?this.headers.build():null;
  }
  public A withHeaders(Headers headers) {
    _visitables.get("headers").remove(this.headers);
    if (headers!=null){ this.headers= new HeadersBuilder(headers); _visitables.get("headers").add(this.headers);} else { this.headers = null; _visitables.get("headers").remove(this.headers); } return (A) this;
  }
  public boolean hasHeaders() {
    return this.headers != null;
  }
  public HeadersNested<A> withNewHeaders() {
    return new HeadersNested(null);
  }
  public HeadersNested<A> withNewHeadersLike(Headers item) {
    return new HeadersNested(item);
  }
  public HeadersNested<A> editHeaders() {
    return withNewHeadersLike(java.util.Optional.ofNullable(buildHeaders()).orElse(null));
  }
  public HeadersNested<A> editOrNewHeaders() {
    return withNewHeadersLike(java.util.Optional.ofNullable(buildHeaders()).orElse(new HeadersBuilder().build()));
  }
  public HeadersNested<A> editOrNewHeadersLike(Headers item) {
    return withNewHeadersLike(java.util.Optional.ofNullable(buildHeaders()).orElse(item));
  }
  public A addToMatch(int index,HTTPMatchRequest item) {
    if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
    HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").add(index, builder); match.add(index, builder);}
    return (A)this;
  }
  public A setToMatch(int index,HTTPMatchRequest item) {
    if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
    HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);
    if (index < 0 || index >= match.size()) { _visitables.get("match").add(builder); match.add(builder); } else { _visitables.get("match").set(index, builder); match.set(index, builder);}
    return (A)this;
  }
  public A addToMatch(io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequest... items) {
    if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
    for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A addAllToMatch(Collection<HTTPMatchRequest> items) {
    if (this.match == null) {this.match = new ArrayList<HTTPMatchRequestBuilder>();}
    for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").add(builder);this.match.add(builder);} return (A)this;
  }
  public A removeFromMatch(io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequest... items) {
    if (this.match == null) return (A)this;
    for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder); this.match.remove(builder);} return (A)this;
  }
  public A removeAllFromMatch(Collection<HTTPMatchRequest> items) {
    if (this.match == null) return (A)this;
    for (HTTPMatchRequest item : items) {HTTPMatchRequestBuilder builder = new HTTPMatchRequestBuilder(item);_visitables.get("match").remove(builder); this.match.remove(builder);} return (A)this;
  }
  public A removeMatchingFromMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
    if (match == null) return (A) this;
    final Iterator<HTTPMatchRequestBuilder> each = match.iterator();
    final List visitables = _visitables.get("match");
    while (each.hasNext()) {
      HTTPMatchRequestBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<HTTPMatchRequest> buildMatch() {
    return match != null ? build(match) : null;
  }
  public HTTPMatchRequest buildMatch(int index) {
    return this.match.get(index).build();
  }
  public HTTPMatchRequest buildFirstMatch() {
    return this.match.get(0).build();
  }
  public HTTPMatchRequest buildLastMatch() {
    return this.match.get(match.size() - 1).build();
  }
  public HTTPMatchRequest buildMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
    for (HTTPMatchRequestBuilder item: match) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
    for (HTTPMatchRequestBuilder item: match) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatch(List<HTTPMatchRequest> match) {
    if (this.match != null) { _visitables.get("match").clear();}
    if (match != null) {this.match = new ArrayList(); for (HTTPMatchRequest item : match){this.addToMatch(item);}} else { this.match = null;} return (A) this;
  }
  public A withMatch(io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequest... match) {
    if (this.match != null) {this.match.clear(); _visitables.remove("match"); }
    if (match != null) {for (HTTPMatchRequest item :match){ this.addToMatch(item);}} return (A) this;
  }
  public boolean hasMatch() {
    return match != null && !match.isEmpty();
  }
  public MatchNested<A> addNewMatch() {
    return new MatchNested(-1, null);
  }
  public MatchNested<A> addNewMatchLike(HTTPMatchRequest item) {
    return new MatchNested(-1, item);
  }
  public MatchNested<A> setNewMatchLike(int index,HTTPMatchRequest item) {
    return new MatchNested(index, item);
  }
  public MatchNested<A> editMatch(int index) {
    if (match.size() <= index) throw new RuntimeException("Can't edit match. Index exceeds size.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public MatchNested<A> editFirstMatch() {
    if (match.size() == 0) throw new RuntimeException("Can't edit first match. The list is empty.");
    return setNewMatchLike(0, buildMatch(0));
  }
  public MatchNested<A> editLastMatch() {
    int index = match.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last match. The list is empty.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public MatchNested<A> editMatchingMatch(Predicate<HTTPMatchRequestBuilder> predicate) {
    int index = -1;
    for (int i=0;i<match.size();i++) { 
    if (predicate.test(match.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching match. No match found.");
    return setNewMatchLike(index, buildMatch(index));
  }
  public Destination buildMirror() {
    return this.mirror!=null ?this.mirror.build():null;
  }
  public A withMirror(Destination mirror) {
    _visitables.get("mirror").remove(this.mirror);
    if (mirror!=null){ this.mirror= new DestinationBuilder(mirror); _visitables.get("mirror").add(this.mirror);} else { this.mirror = null; _visitables.get("mirror").remove(this.mirror); } return (A) this;
  }
  public boolean hasMirror() {
    return this.mirror != null;
  }
  public MirrorNested<A> withNewMirror() {
    return new MirrorNested(null);
  }
  public MirrorNested<A> withNewMirrorLike(Destination item) {
    return new MirrorNested(item);
  }
  public MirrorNested<A> editMirror() {
    return withNewMirrorLike(java.util.Optional.ofNullable(buildMirror()).orElse(null));
  }
  public MirrorNested<A> editOrNewMirror() {
    return withNewMirrorLike(java.util.Optional.ofNullable(buildMirror()).orElse(new DestinationBuilder().build()));
  }
  public MirrorNested<A> editOrNewMirrorLike(Destination item) {
    return withNewMirrorLike(java.util.Optional.ofNullable(buildMirror()).orElse(item));
  }
  public Integer getMirrorPercent() {
    return this.mirrorPercent;
  }
  public A withMirrorPercent(Integer mirrorPercent) {
    this.mirrorPercent=mirrorPercent; return (A) this;
  }
  public boolean hasMirrorPercent() {
    return this.mirrorPercent != null;
  }
  public Percent buildMirrorPercentage() {
    return this.mirrorPercentage!=null ?this.mirrorPercentage.build():null;
  }
  public A withMirrorPercentage(Percent mirrorPercentage) {
    _visitables.get("mirrorPercentage").remove(this.mirrorPercentage);
    if (mirrorPercentage!=null){ this.mirrorPercentage= new PercentBuilder(mirrorPercentage); _visitables.get("mirrorPercentage").add(this.mirrorPercentage);} else { this.mirrorPercentage = null; _visitables.get("mirrorPercentage").remove(this.mirrorPercentage); } return (A) this;
  }
  public boolean hasMirrorPercentage() {
    return this.mirrorPercentage != null;
  }
  public A withNewMirrorPercentage(Double value) {
    return (A)withMirrorPercentage(new Percent(value));
  }
  public MirrorPercentageNested<A> withNewMirrorPercentage() {
    return new MirrorPercentageNested(null);
  }
  public MirrorPercentageNested<A> withNewMirrorPercentageLike(Percent item) {
    return new MirrorPercentageNested(item);
  }
  public MirrorPercentageNested<A> editMirrorPercentage() {
    return withNewMirrorPercentageLike(java.util.Optional.ofNullable(buildMirrorPercentage()).orElse(null));
  }
  public MirrorPercentageNested<A> editOrNewMirrorPercentage() {
    return withNewMirrorPercentageLike(java.util.Optional.ofNullable(buildMirrorPercentage()).orElse(new PercentBuilder().build()));
  }
  public MirrorPercentageNested<A> editOrNewMirrorPercentageLike(Percent item) {
    return withNewMirrorPercentageLike(java.util.Optional.ofNullable(buildMirrorPercentage()).orElse(item));
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public boolean hasName() {
    return this.name != null;
  }
  public HTTPRedirect buildRedirect() {
    return this.redirect!=null ?this.redirect.build():null;
  }
  public A withRedirect(HTTPRedirect redirect) {
    _visitables.get("redirect").remove(this.redirect);
    if (redirect!=null){ this.redirect= new HTTPRedirectBuilder(redirect); _visitables.get("redirect").add(this.redirect);} else { this.redirect = null; _visitables.get("redirect").remove(this.redirect); } return (A) this;
  }
  public boolean hasRedirect() {
    return this.redirect != null;
  }
  public RedirectNested<A> withNewRedirect() {
    return new RedirectNested(null);
  }
  public RedirectNested<A> withNewRedirectLike(HTTPRedirect item) {
    return new RedirectNested(item);
  }
  public RedirectNested<A> editRedirect() {
    return withNewRedirectLike(java.util.Optional.ofNullable(buildRedirect()).orElse(null));
  }
  public RedirectNested<A> editOrNewRedirect() {
    return withNewRedirectLike(java.util.Optional.ofNullable(buildRedirect()).orElse(new HTTPRedirectBuilder().build()));
  }
  public RedirectNested<A> editOrNewRedirectLike(HTTPRedirect item) {
    return withNewRedirectLike(java.util.Optional.ofNullable(buildRedirect()).orElse(item));
  }
  public HTTPRetry buildRetries() {
    return this.retries!=null ?this.retries.build():null;
  }
  public A withRetries(HTTPRetry retries) {
    _visitables.get("retries").remove(this.retries);
    if (retries!=null){ this.retries= new HTTPRetryBuilder(retries); _visitables.get("retries").add(this.retries);} else { this.retries = null; _visitables.get("retries").remove(this.retries); } return (A) this;
  }
  public boolean hasRetries() {
    return this.retries != null;
  }
  public A withNewRetries(Integer attempts,String perTryTimeout,String retryOn,Boolean retryRemoteLocalities) {
    return (A)withRetries(new HTTPRetry(attempts, perTryTimeout, retryOn, retryRemoteLocalities));
  }
  public RetriesNested<A> withNewRetries() {
    return new RetriesNested(null);
  }
  public RetriesNested<A> withNewRetriesLike(HTTPRetry item) {
    return new RetriesNested(item);
  }
  public RetriesNested<A> editRetries() {
    return withNewRetriesLike(java.util.Optional.ofNullable(buildRetries()).orElse(null));
  }
  public RetriesNested<A> editOrNewRetries() {
    return withNewRetriesLike(java.util.Optional.ofNullable(buildRetries()).orElse(new HTTPRetryBuilder().build()));
  }
  public RetriesNested<A> editOrNewRetriesLike(HTTPRetry item) {
    return withNewRetriesLike(java.util.Optional.ofNullable(buildRetries()).orElse(item));
  }
  public HTTPRewrite buildRewrite() {
    return this.rewrite!=null ?this.rewrite.build():null;
  }
  public A withRewrite(HTTPRewrite rewrite) {
    _visitables.get("rewrite").remove(this.rewrite);
    if (rewrite!=null){ this.rewrite= new HTTPRewriteBuilder(rewrite); _visitables.get("rewrite").add(this.rewrite);} else { this.rewrite = null; _visitables.get("rewrite").remove(this.rewrite); } return (A) this;
  }
  public boolean hasRewrite() {
    return this.rewrite != null;
  }
  public A withNewRewrite(String authority,String uri) {
    return (A)withRewrite(new HTTPRewrite(authority, uri));
  }
  public RewriteNested<A> withNewRewrite() {
    return new RewriteNested(null);
  }
  public RewriteNested<A> withNewRewriteLike(HTTPRewrite item) {
    return new RewriteNested(item);
  }
  public RewriteNested<A> editRewrite() {
    return withNewRewriteLike(java.util.Optional.ofNullable(buildRewrite()).orElse(null));
  }
  public RewriteNested<A> editOrNewRewrite() {
    return withNewRewriteLike(java.util.Optional.ofNullable(buildRewrite()).orElse(new HTTPRewriteBuilder().build()));
  }
  public RewriteNested<A> editOrNewRewriteLike(HTTPRewrite item) {
    return withNewRewriteLike(java.util.Optional.ofNullable(buildRewrite()).orElse(item));
  }
  public A addToRoute(int index,HTTPRouteDestination item) {
    if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
    HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
    if (index < 0 || index >= route.size()) { _visitables.get("route").add(builder); route.add(builder); } else { _visitables.get("route").add(index, builder); route.add(index, builder);}
    return (A)this;
  }
  public A setToRoute(int index,HTTPRouteDestination item) {
    if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
    HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);
    if (index < 0 || index >= route.size()) { _visitables.get("route").add(builder); route.add(builder); } else { _visitables.get("route").set(index, builder); route.set(index, builder);}
    return (A)this;
  }
  public A addToRoute(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination... items) {
    if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
    for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
  }
  public A addAllToRoute(Collection<HTTPRouteDestination> items) {
    if (this.route == null) {this.route = new ArrayList<HTTPRouteDestinationBuilder>();}
    for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").add(builder);this.route.add(builder);} return (A)this;
  }
  public A removeFromRoute(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination... items) {
    if (this.route == null) return (A)this;
    for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder); this.route.remove(builder);} return (A)this;
  }
  public A removeAllFromRoute(Collection<HTTPRouteDestination> items) {
    if (this.route == null) return (A)this;
    for (HTTPRouteDestination item : items) {HTTPRouteDestinationBuilder builder = new HTTPRouteDestinationBuilder(item);_visitables.get("route").remove(builder); this.route.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
    if (route == null) return (A) this;
    final Iterator<HTTPRouteDestinationBuilder> each = route.iterator();
    final List visitables = _visitables.get("route");
    while (each.hasNext()) {
      HTTPRouteDestinationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<HTTPRouteDestination> buildRoute() {
    return route != null ? build(route) : null;
  }
  public HTTPRouteDestination buildRoute(int index) {
    return this.route.get(index).build();
  }
  public HTTPRouteDestination buildFirstRoute() {
    return this.route.get(0).build();
  }
  public HTTPRouteDestination buildLastRoute() {
    return this.route.get(route.size() - 1).build();
  }
  public HTTPRouteDestination buildMatchingRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
    for (HTTPRouteDestinationBuilder item: route) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
    for (HTTPRouteDestinationBuilder item: route) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRoute(List<HTTPRouteDestination> route) {
    if (this.route != null) { _visitables.get("route").clear();}
    if (route != null) {this.route = new ArrayList(); for (HTTPRouteDestination item : route){this.addToRoute(item);}} else { this.route = null;} return (A) this;
  }
  public A withRoute(io.fabric8.istio.api.networking.v1alpha3.HTTPRouteDestination... route) {
    if (this.route != null) {this.route.clear(); _visitables.remove("route"); }
    if (route != null) {for (HTTPRouteDestination item :route){ this.addToRoute(item);}} return (A) this;
  }
  public boolean hasRoute() {
    return route != null && !route.isEmpty();
  }
  public RouteNested<A> addNewRoute() {
    return new RouteNested(-1, null);
  }
  public RouteNested<A> addNewRouteLike(HTTPRouteDestination item) {
    return new RouteNested(-1, item);
  }
  public RouteNested<A> setNewRouteLike(int index,HTTPRouteDestination item) {
    return new RouteNested(index, item);
  }
  public RouteNested<A> editRoute(int index) {
    if (route.size() <= index) throw new RuntimeException("Can't edit route. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public RouteNested<A> editFirstRoute() {
    if (route.size() == 0) throw new RuntimeException("Can't edit first route. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  public RouteNested<A> editLastRoute() {
    int index = route.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last route. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public RouteNested<A> editMatchingRoute(Predicate<HTTPRouteDestinationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<route.size();i++) { 
    if (predicate.test(route.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching route. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  public String getTimeout() {
    return this.timeout;
  }
  public A withTimeout(String timeout) {
    this.timeout=timeout; return (A) this;
  }
  public boolean hasTimeout() {
    return this.timeout != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRouteFluent that = (HTTPRouteFluent) o;
    if (!java.util.Objects.equals(corsPolicy, that.corsPolicy)) return false;

    if (!java.util.Objects.equals(delegate, that.delegate)) return false;

    if (!java.util.Objects.equals(fault, that.fault)) return false;

    if (!java.util.Objects.equals(headers, that.headers)) return false;

    if (!java.util.Objects.equals(match, that.match)) return false;

    if (!java.util.Objects.equals(mirror, that.mirror)) return false;

    if (!java.util.Objects.equals(mirrorPercent, that.mirrorPercent)) return false;

    if (!java.util.Objects.equals(mirrorPercentage, that.mirrorPercentage)) return false;

    if (!java.util.Objects.equals(name, that.name)) return false;

    if (!java.util.Objects.equals(redirect, that.redirect)) return false;

    if (!java.util.Objects.equals(retries, that.retries)) return false;

    if (!java.util.Objects.equals(rewrite, that.rewrite)) return false;

    if (!java.util.Objects.equals(route, that.route)) return false;

    if (!java.util.Objects.equals(timeout, that.timeout)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(corsPolicy,  delegate,  fault,  headers,  match,  mirror,  mirrorPercent,  mirrorPercentage,  name,  redirect,  retries,  rewrite,  route,  timeout,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (corsPolicy != null) { sb.append("corsPolicy:"); sb.append(corsPolicy + ","); }
    if (delegate != null) { sb.append("delegate:"); sb.append(delegate + ","); }
    if (fault != null) { sb.append("fault:"); sb.append(fault + ","); }
    if (headers != null) { sb.append("headers:"); sb.append(headers + ","); }
    if (match != null && !match.isEmpty()) { sb.append("match:"); sb.append(match + ","); }
    if (mirror != null) { sb.append("mirror:"); sb.append(mirror + ","); }
    if (mirrorPercent != null) { sb.append("mirrorPercent:"); sb.append(mirrorPercent + ","); }
    if (mirrorPercentage != null) { sb.append("mirrorPercentage:"); sb.append(mirrorPercentage + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (redirect != null) { sb.append("redirect:"); sb.append(redirect + ","); }
    if (retries != null) { sb.append("retries:"); sb.append(retries + ","); }
    if (rewrite != null) { sb.append("rewrite:"); sb.append(rewrite + ","); }
    if (route != null && !route.isEmpty()) { sb.append("route:"); sb.append(route + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout); }
    sb.append("}");
    return sb.toString();
  }
  public class CorsPolicyNested<N> extends CorsPolicyFluent<CorsPolicyNested<N>> implements Nested<N>{
    CorsPolicyNested(CorsPolicy item) {
      this.builder = new CorsPolicyBuilder(this, item);
    }
    CorsPolicyBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withCorsPolicy(builder.build());
    }
    public N endCorsPolicy() {
      return and();
    }
    
  }
  public class DelegateNested<N> extends DelegateFluent<DelegateNested<N>> implements Nested<N>{
    DelegateNested(Delegate item) {
      this.builder = new DelegateBuilder(this, item);
    }
    DelegateBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withDelegate(builder.build());
    }
    public N endDelegate() {
      return and();
    }
    
  }
  public class FaultNested<N> extends HTTPFaultInjectionFluent<FaultNested<N>> implements Nested<N>{
    FaultNested(HTTPFaultInjection item) {
      this.builder = new HTTPFaultInjectionBuilder(this, item);
    }
    HTTPFaultInjectionBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withFault(builder.build());
    }
    public N endFault() {
      return and();
    }
    
  }
  public class HeadersNested<N> extends HeadersFluent<HeadersNested<N>> implements Nested<N>{
    HeadersNested(Headers item) {
      this.builder = new HeadersBuilder(this, item);
    }
    HeadersBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withHeaders(builder.build());
    }
    public N endHeaders() {
      return and();
    }
    
  }
  public class MatchNested<N> extends HTTPMatchRequestFluent<MatchNested<N>> implements Nested<N>{
    MatchNested(int index,HTTPMatchRequest item) {
      this.index = index;
      this.builder = new HTTPMatchRequestBuilder(this, item);
    }
    HTTPMatchRequestBuilder builder;
    int index;
    public N and() {
      return (N) HTTPRouteFluent.this.setToMatch(index,builder.build());
    }
    public N endMatch() {
      return and();
    }
    
  }
  public class MirrorNested<N> extends DestinationFluent<MirrorNested<N>> implements Nested<N>{
    MirrorNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withMirror(builder.build());
    }
    public N endMirror() {
      return and();
    }
    
  }
  public class MirrorPercentageNested<N> extends PercentFluent<MirrorPercentageNested<N>> implements Nested<N>{
    MirrorPercentageNested(Percent item) {
      this.builder = new PercentBuilder(this, item);
    }
    PercentBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withMirrorPercentage(builder.build());
    }
    public N endMirrorPercentage() {
      return and();
    }
    
  }
  public class RedirectNested<N> extends HTTPRedirectFluent<RedirectNested<N>> implements Nested<N>{
    RedirectNested(HTTPRedirect item) {
      this.builder = new HTTPRedirectBuilder(this, item);
    }
    HTTPRedirectBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withRedirect(builder.build());
    }
    public N endRedirect() {
      return and();
    }
    
  }
  public class RetriesNested<N> extends HTTPRetryFluent<RetriesNested<N>> implements Nested<N>{
    RetriesNested(HTTPRetry item) {
      this.builder = new HTTPRetryBuilder(this, item);
    }
    HTTPRetryBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withRetries(builder.build());
    }
    public N endRetries() {
      return and();
    }
    
  }
  public class RewriteNested<N> extends HTTPRewriteFluent<RewriteNested<N>> implements Nested<N>{
    RewriteNested(HTTPRewrite item) {
      this.builder = new HTTPRewriteBuilder(this, item);
    }
    HTTPRewriteBuilder builder;
    public N and() {
      return (N) HTTPRouteFluent.this.withRewrite(builder.build());
    }
    public N endRewrite() {
      return and();
    }
    
  }
  public class RouteNested<N> extends HTTPRouteDestinationFluent<RouteNested<N>> implements Nested<N>{
    RouteNested(int index,HTTPRouteDestination item) {
      this.index = index;
      this.builder = new HTTPRouteDestinationBuilder(this, item);
    }
    HTTPRouteDestinationBuilder builder;
    int index;
    public N and() {
      return (N) HTTPRouteFluent.this.setToRoute(index,builder.build());
    }
    public N endRoute() {
      return and();
    }
    
  }
  
}