package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRedirectPortBuilder extends HTTPRedirectPortFluent<HTTPRedirectPortBuilder> implements VisitableBuilder<HTTPRedirectPort,HTTPRedirectPortBuilder>{
  public HTTPRedirectPortBuilder() {
    this(false);
  }
  public HTTPRedirectPortBuilder(Boolean validationEnabled) {
    this(new HTTPRedirectPort(), validationEnabled);
  }
  public HTTPRedirectPortBuilder(HTTPRedirectPortFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRedirectPortBuilder(HTTPRedirectPortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRedirectPort(), validationEnabled);
  }
  public HTTPRedirectPortBuilder(HTTPRedirectPortFluent<?> fluent,HTTPRedirectPort instance) {
    this(fluent, instance, false);
  }
  public HTTPRedirectPortBuilder(HTTPRedirectPortFluent<?> fluent,HTTPRedirectPort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPRedirectPort());

    if (instance != null) {
      fluent.withPort(instance.getPort());
      fluent.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRedirectPortBuilder(HTTPRedirectPort instance) {
    this(instance,false);
  }
  public HTTPRedirectPortBuilder(HTTPRedirectPort instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPRedirectPort());

    if (instance != null) {
      this.withPort(instance.getPort());
      this.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPRedirectPortFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRedirectPort build() {
    HTTPRedirectPort buildable = new HTTPRedirectPort(fluent.getPort());
    return buildable;
  }
  
}