package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecHealthCheckConfigBuilder extends ExecHealthCheckConfigFluent<ExecHealthCheckConfigBuilder> implements VisitableBuilder<ExecHealthCheckConfig,ExecHealthCheckConfigBuilder>{
  public ExecHealthCheckConfigBuilder() {
    this(false);
  }
  public ExecHealthCheckConfigBuilder(Boolean validationEnabled) {
    this(new ExecHealthCheckConfig(), validationEnabled);
  }
  public ExecHealthCheckConfigBuilder(ExecHealthCheckConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecHealthCheckConfigBuilder(ExecHealthCheckConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExecHealthCheckConfig(), validationEnabled);
  }
  public ExecHealthCheckConfigBuilder(ExecHealthCheckConfigFluent<?> fluent,ExecHealthCheckConfig instance) {
    this(fluent, instance, false);
  }
  public ExecHealthCheckConfigBuilder(ExecHealthCheckConfigFluent<?> fluent,ExecHealthCheckConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExecHealthCheckConfig());

    if (instance != null) {
      fluent.withCommand(instance.getCommand());
      fluent.withCommand(instance.getCommand());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExecHealthCheckConfigBuilder(ExecHealthCheckConfig instance) {
    this(instance,false);
  }
  public ExecHealthCheckConfigBuilder(ExecHealthCheckConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExecHealthCheckConfig());

    if (instance != null) {
      this.withCommand(instance.getCommand());
      this.withCommand(instance.getCommand());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExecHealthCheckConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ExecHealthCheckConfig build() {
    ExecHealthCheckConfig buildable = new ExecHealthCheckConfig(fluent.getCommand());
    return buildable;
  }
  
}