package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvoyFilterPatchBuilder extends EnvoyFilterPatchFluent<EnvoyFilterPatchBuilder> implements VisitableBuilder<EnvoyFilterPatch,EnvoyFilterPatchBuilder>{
  public EnvoyFilterPatchBuilder() {
    this(false);
  }
  public EnvoyFilterPatchBuilder(Boolean validationEnabled) {
    this(new EnvoyFilterPatch(), validationEnabled);
  }
  public EnvoyFilterPatchBuilder(EnvoyFilterPatchFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvoyFilterPatchBuilder(EnvoyFilterPatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvoyFilterPatch(), validationEnabled);
  }
  public EnvoyFilterPatchBuilder(EnvoyFilterPatchFluent<?> fluent,EnvoyFilterPatch instance) {
    this(fluent, instance, false);
  }
  public EnvoyFilterPatchBuilder(EnvoyFilterPatchFluent<?> fluent,EnvoyFilterPatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EnvoyFilterPatch());

    if (instance != null) {
      fluent.withFilterClass(instance.getFilterClass());
      fluent.withOperation(instance.getOperation());
      fluent.withValue(instance.getValue());
      fluent.withFilterClass(instance.getFilterClass());
      fluent.withOperation(instance.getOperation());
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EnvoyFilterPatchBuilder(EnvoyFilterPatch instance) {
    this(instance,false);
  }
  public EnvoyFilterPatchBuilder(EnvoyFilterPatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EnvoyFilterPatch());

    if (instance != null) {
      this.withFilterClass(instance.getFilterClass());
      this.withOperation(instance.getOperation());
      this.withValue(instance.getValue());
      this.withFilterClass(instance.getFilterClass());
      this.withOperation(instance.getOperation());
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  EnvoyFilterPatchFluent<?> fluent;
  Boolean validationEnabled;
  public EnvoyFilterPatch build() {
    EnvoyFilterPatch buildable = new EnvoyFilterPatch(fluent.getFilterClass(),fluent.getOperation(),fluent.getValue());
    return buildable;
  }
  
}