package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConnectionPoolSettingsBuilder extends ConnectionPoolSettingsFluent<ConnectionPoolSettingsBuilder> implements VisitableBuilder<ConnectionPoolSettings,ConnectionPoolSettingsBuilder>{
  public ConnectionPoolSettingsBuilder() {
    this(false);
  }
  public ConnectionPoolSettingsBuilder(Boolean validationEnabled) {
    this(new ConnectionPoolSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConnectionPoolSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,ConnectionPoolSettings instance) {
    this(fluent, instance, false);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,ConnectionPoolSettings instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ConnectionPoolSettings());

    if (instance != null) {
      fluent.withHttp(instance.getHttp());
      fluent.withTcp(instance.getTcp());
      fluent.withHttp(instance.getHttp());
      fluent.withTcp(instance.getTcp());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettings instance) {
    this(instance,false);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettings instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ConnectionPoolSettings());

    if (instance != null) {
      this.withHttp(instance.getHttp());
      this.withTcp(instance.getTcp());
      this.withHttp(instance.getHttp());
      this.withTcp(instance.getTcp());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConnectionPoolSettingsFluent<?> fluent;
  Boolean validationEnabled;
  public ConnectionPoolSettings build() {
    ConnectionPoolSettings buildable = new ConnectionPoolSettings(fluent.buildHttp(),fluent.buildTcp());
    return buildable;
  }
  
}