package io.fabric8.istio.api.meta.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.istio.api.analysis.v1alpha1.AnalysisMessageBaseBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.istio.api.analysis.v1alpha1.AnalysisMessageBaseFluent;
import io.fabric8.istio.api.analysis.v1alpha1.AnalysisMessageBase;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IstioStatusFluent<A extends IstioStatusFluent<A>> extends BaseFluent<A>{
  public IstioStatusFluent() {
  }
  public IstioStatusFluent(IstioStatus instance) {
    instance = (instance != null ? instance : new IstioStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withValidationMessages(instance.getValidationMessages());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withValidationMessages(instance.getValidationMessages());
    }
  }
  private ArrayList<IstioConditionBuilder> conditions = new ArrayList<IstioConditionBuilder>();
  private Long observedGeneration;
  private ArrayList<AnalysisMessageBaseBuilder> validationMessages = new ArrayList<AnalysisMessageBaseBuilder>();
  public A addToConditions(int index,IstioCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IstioConditionBuilder>();}
    IstioConditionBuilder builder = new IstioConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,IstioCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IstioConditionBuilder>();}
    IstioConditionBuilder builder = new IstioConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.istio.api.meta.v1alpha1.IstioCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IstioConditionBuilder>();}
    for (IstioCondition item : items) {IstioConditionBuilder builder = new IstioConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<IstioCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IstioConditionBuilder>();}
    for (IstioCondition item : items) {IstioConditionBuilder builder = new IstioConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.istio.api.meta.v1alpha1.IstioCondition... items) {
    if (this.conditions == null) return (A)this;
    for (IstioCondition item : items) {IstioConditionBuilder builder = new IstioConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeAllFromConditions(Collection<IstioCondition> items) {
    if (this.conditions == null) return (A)this;
    for (IstioCondition item : items) {IstioConditionBuilder builder = new IstioConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<IstioConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<IstioConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      IstioConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<IstioCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public IstioCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public IstioCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public IstioCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public IstioCondition buildMatchingCondition(Predicate<IstioConditionBuilder> predicate) {
    for (IstioConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingCondition(Predicate<IstioConditionBuilder> predicate) {
    for (IstioConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<IstioCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (IstioCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.istio.api.meta.v1alpha1.IstioCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (IstioCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  public ConditionsNested<A> addNewConditionLike(IstioCondition item) {
    return new ConditionsNested(-1, item);
  }
  public ConditionsNested<A> setNewConditionLike(int index,IstioCondition item) {
    return new ConditionsNested(index, item);
  }
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public ConditionsNested<A> editMatchingCondition(Predicate<IstioConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public A addToValidationMessages(int index,AnalysisMessageBase item) {
    if (this.validationMessages == null) {this.validationMessages = new ArrayList<AnalysisMessageBaseBuilder>();}
    AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
    if (index < 0 || index >= validationMessages.size()) { _visitables.get("validationMessages").add(builder); validationMessages.add(builder); } else { _visitables.get("validationMessages").add(index, builder); validationMessages.add(index, builder);}
    return (A)this;
  }
  public A setToValidationMessages(int index,AnalysisMessageBase item) {
    if (this.validationMessages == null) {this.validationMessages = new ArrayList<AnalysisMessageBaseBuilder>();}
    AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);
    if (index < 0 || index >= validationMessages.size()) { _visitables.get("validationMessages").add(builder); validationMessages.add(builder); } else { _visitables.get("validationMessages").set(index, builder); validationMessages.set(index, builder);}
    return (A)this;
  }
  public A addToValidationMessages(io.fabric8.istio.api.analysis.v1alpha1.AnalysisMessageBase... items) {
    if (this.validationMessages == null) {this.validationMessages = new ArrayList<AnalysisMessageBaseBuilder>();}
    for (AnalysisMessageBase item : items) {AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);_visitables.get("validationMessages").add(builder);this.validationMessages.add(builder);} return (A)this;
  }
  public A addAllToValidationMessages(Collection<AnalysisMessageBase> items) {
    if (this.validationMessages == null) {this.validationMessages = new ArrayList<AnalysisMessageBaseBuilder>();}
    for (AnalysisMessageBase item : items) {AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);_visitables.get("validationMessages").add(builder);this.validationMessages.add(builder);} return (A)this;
  }
  public A removeFromValidationMessages(io.fabric8.istio.api.analysis.v1alpha1.AnalysisMessageBase... items) {
    if (this.validationMessages == null) return (A)this;
    for (AnalysisMessageBase item : items) {AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);_visitables.get("validationMessages").remove(builder); this.validationMessages.remove(builder);} return (A)this;
  }
  public A removeAllFromValidationMessages(Collection<AnalysisMessageBase> items) {
    if (this.validationMessages == null) return (A)this;
    for (AnalysisMessageBase item : items) {AnalysisMessageBaseBuilder builder = new AnalysisMessageBaseBuilder(item);_visitables.get("validationMessages").remove(builder); this.validationMessages.remove(builder);} return (A)this;
  }
  public A removeMatchingFromValidationMessages(Predicate<AnalysisMessageBaseBuilder> predicate) {
    if (validationMessages == null) return (A) this;
    final Iterator<AnalysisMessageBaseBuilder> each = validationMessages.iterator();
    final List visitables = _visitables.get("validationMessages");
    while (each.hasNext()) {
      AnalysisMessageBaseBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<AnalysisMessageBase> buildValidationMessages() {
    return validationMessages != null ? build(validationMessages) : null;
  }
  public AnalysisMessageBase buildValidationMessage(int index) {
    return this.validationMessages.get(index).build();
  }
  public AnalysisMessageBase buildFirstValidationMessage() {
    return this.validationMessages.get(0).build();
  }
  public AnalysisMessageBase buildLastValidationMessage() {
    return this.validationMessages.get(validationMessages.size() - 1).build();
  }
  public AnalysisMessageBase buildMatchingValidationMessage(Predicate<AnalysisMessageBaseBuilder> predicate) {
    for (AnalysisMessageBaseBuilder item: validationMessages) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingValidationMessage(Predicate<AnalysisMessageBaseBuilder> predicate) {
    for (AnalysisMessageBaseBuilder item: validationMessages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withValidationMessages(List<AnalysisMessageBase> validationMessages) {
    if (this.validationMessages != null) { _visitables.get("validationMessages").clear();}
    if (validationMessages != null) {this.validationMessages = new ArrayList(); for (AnalysisMessageBase item : validationMessages){this.addToValidationMessages(item);}} else { this.validationMessages = null;} return (A) this;
  }
  public A withValidationMessages(io.fabric8.istio.api.analysis.v1alpha1.AnalysisMessageBase... validationMessages) {
    if (this.validationMessages != null) {this.validationMessages.clear(); _visitables.remove("validationMessages"); }
    if (validationMessages != null) {for (AnalysisMessageBase item :validationMessages){ this.addToValidationMessages(item);}} return (A) this;
  }
  public boolean hasValidationMessages() {
    return validationMessages != null && !validationMessages.isEmpty();
  }
  public ValidationMessagesNested<A> addNewValidationMessage() {
    return new ValidationMessagesNested(-1, null);
  }
  public ValidationMessagesNested<A> addNewValidationMessageLike(AnalysisMessageBase item) {
    return new ValidationMessagesNested(-1, item);
  }
  public ValidationMessagesNested<A> setNewValidationMessageLike(int index,AnalysisMessageBase item) {
    return new ValidationMessagesNested(index, item);
  }
  public ValidationMessagesNested<A> editValidationMessage(int index) {
    if (validationMessages.size() <= index) throw new RuntimeException("Can't edit validationMessages. Index exceeds size.");
    return setNewValidationMessageLike(index, buildValidationMessage(index));
  }
  public ValidationMessagesNested<A> editFirstValidationMessage() {
    if (validationMessages.size() == 0) throw new RuntimeException("Can't edit first validationMessages. The list is empty.");
    return setNewValidationMessageLike(0, buildValidationMessage(0));
  }
  public ValidationMessagesNested<A> editLastValidationMessage() {
    int index = validationMessages.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last validationMessages. The list is empty.");
    return setNewValidationMessageLike(index, buildValidationMessage(index));
  }
  public ValidationMessagesNested<A> editMatchingValidationMessage(Predicate<AnalysisMessageBaseBuilder> predicate) {
    int index = -1;
    for (int i=0;i<validationMessages.size();i++) { 
    if (predicate.test(validationMessages.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching validationMessages. No match found.");
    return setNewValidationMessageLike(index, buildValidationMessage(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IstioStatusFluent that = (IstioStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;

    if (!java.util.Objects.equals(validationMessages, that.validationMessages)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conditions,  observedGeneration,  validationMessages,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (validationMessages != null && !validationMessages.isEmpty()) { sb.append("validationMessages:"); sb.append(validationMessages); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends IstioConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,IstioCondition item) {
      this.index = index;
      this.builder = new IstioConditionBuilder(this, item);
    }
    IstioConditionBuilder builder;
    int index;
    public N and() {
      return (N) IstioStatusFluent.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  public class ValidationMessagesNested<N> extends AnalysisMessageBaseFluent<ValidationMessagesNested<N>> implements Nested<N>{
    ValidationMessagesNested(int index,AnalysisMessageBase item) {
      this.index = index;
      this.builder = new AnalysisMessageBaseBuilder(this, item);
    }
    AnalysisMessageBaseBuilder builder;
    int index;
    public N and() {
      return (N) IstioStatusFluent.this.setToValidationMessages(index,builder.build());
    }
    public N endValidationMessage() {
      return and();
    }
    
  }
  
}