package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueStructValueBuilder extends ValueStructValueFluent<ValueStructValueBuilder> implements VisitableBuilder<ValueStructValue,ValueStructValueBuilder>{
  public ValueStructValueBuilder() {
    this(false);
  }
  public ValueStructValueBuilder(Boolean validationEnabled) {
    this(new ValueStructValue(), validationEnabled);
  }
  public ValueStructValueBuilder(ValueStructValueFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueStructValueBuilder(ValueStructValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValueStructValue(), validationEnabled);
  }
  public ValueStructValueBuilder(ValueStructValueFluent<?> fluent,ValueStructValue instance) {
    this(fluent, instance, false);
  }
  public ValueStructValueBuilder(ValueStructValueFluent<?> fluent,ValueStructValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValueStructValue());

    if (instance != null) {
      fluent.withStructValue(instance.getStructValue());
      fluent.withStructValue(instance.getStructValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValueStructValueBuilder(ValueStructValue instance) {
    this(instance,false);
  }
  public ValueStructValueBuilder(ValueStructValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValueStructValue());

    if (instance != null) {
      this.withStructValue(instance.getStructValue());
      this.withStructValue(instance.getStructValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValueStructValueFluent<?> fluent;
  Boolean validationEnabled;
  public ValueStructValue build() {
    ValueStructValue buildable = new ValueStructValue(fluent.getStructValue());
    return buildable;
  }
  
}