package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueStringValueBuilder extends ValueStringValueFluent<ValueStringValueBuilder> implements VisitableBuilder<ValueStringValue,ValueStringValueBuilder>{
  public ValueStringValueBuilder() {
    this(false);
  }
  public ValueStringValueBuilder(Boolean validationEnabled) {
    this(new ValueStringValue(), validationEnabled);
  }
  public ValueStringValueBuilder(ValueStringValueFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueStringValueBuilder(ValueStringValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValueStringValue(), validationEnabled);
  }
  public ValueStringValueBuilder(ValueStringValueFluent<?> fluent,ValueStringValue instance) {
    this(fluent, instance, false);
  }
  public ValueStringValueBuilder(ValueStringValueFluent<?> fluent,ValueStringValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValueStringValue());

    if (instance != null) {
      fluent.withStringValue(instance.getStringValue());
      fluent.withStringValue(instance.getStringValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValueStringValueBuilder(ValueStringValue instance) {
    this(instance,false);
  }
  public ValueStringValueBuilder(ValueStringValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValueStringValue());

    if (instance != null) {
      this.withStringValue(instance.getStringValue());
      this.withStringValue(instance.getStringValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValueStringValueFluent<?> fluent;
  Boolean validationEnabled;
  public ValueStringValue build() {
    ValueStringValue buildable = new ValueStringValue(fluent.getStringValue());
    return buildable;
  }
  
}