package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadGroupListBuilder extends WorkloadGroupListFluent<WorkloadGroupListBuilder> implements VisitableBuilder<WorkloadGroupList,WorkloadGroupListBuilder>{
  public WorkloadGroupListBuilder() {
    this(false);
  }
  public WorkloadGroupListBuilder(Boolean validationEnabled) {
    this(new WorkloadGroupList(), validationEnabled);
  }
  public WorkloadGroupListBuilder(WorkloadGroupListFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadGroupListBuilder(WorkloadGroupListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadGroupList(), validationEnabled);
  }
  public WorkloadGroupListBuilder(WorkloadGroupListFluent<?> fluent,WorkloadGroupList instance) {
    this(fluent, instance, false);
  }
  public WorkloadGroupListBuilder(WorkloadGroupListFluent<?> fluent,WorkloadGroupList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WorkloadGroupList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadGroupListBuilder(WorkloadGroupList instance) {
    this(instance,false);
  }
  public WorkloadGroupListBuilder(WorkloadGroupList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WorkloadGroupList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkloadGroupListFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadGroupList build() {
    WorkloadGroupList buildable = new WorkloadGroupList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}