package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadGroupBuilder extends WorkloadGroupFluent<WorkloadGroupBuilder> implements VisitableBuilder<WorkloadGroup,WorkloadGroupBuilder>{
  public WorkloadGroupBuilder() {
    this(false);
  }
  public WorkloadGroupBuilder(Boolean validationEnabled) {
    this(new WorkloadGroup(), validationEnabled);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadGroup(), validationEnabled);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent,WorkloadGroup instance) {
    this(fluent, instance, false);
  }
  public WorkloadGroupBuilder(WorkloadGroupFluent<?> fluent,WorkloadGroup instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WorkloadGroup());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadGroupBuilder(WorkloadGroup instance) {
    this(instance,false);
  }
  public WorkloadGroupBuilder(WorkloadGroup instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WorkloadGroup());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  WorkloadGroupFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadGroup build() {
    WorkloadGroup buildable = new WorkloadGroup(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}