package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VirtualServiceSpecBuilder extends VirtualServiceSpecFluent<VirtualServiceSpecBuilder> implements VisitableBuilder<VirtualServiceSpec,VirtualServiceSpecBuilder>{
  public VirtualServiceSpecBuilder() {
    this(false);
  }
  public VirtualServiceSpecBuilder(Boolean validationEnabled) {
    this(new VirtualServiceSpec(), validationEnabled);
  }
  public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VirtualServiceSpec(), validationEnabled);
  }
  public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,VirtualServiceSpec instance) {
    this(fluent, instance, false);
  }
  public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,VirtualServiceSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VirtualServiceSpec());

    if (instance != null) {
      fluent.withExportTo(instance.getExportTo());
      fluent.withGateways(instance.getGateways());
      fluent.withHosts(instance.getHosts());
      fluent.withHttp(instance.getHttp());
      fluent.withTcp(instance.getTcp());
      fluent.withTls(instance.getTls());
      fluent.withExportTo(instance.getExportTo());
      fluent.withGateways(instance.getGateways());
      fluent.withHosts(instance.getHosts());
      fluent.withHttp(instance.getHttp());
      fluent.withTcp(instance.getTcp());
      fluent.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VirtualServiceSpecBuilder(VirtualServiceSpec instance) {
    this(instance,false);
  }
  public VirtualServiceSpecBuilder(VirtualServiceSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VirtualServiceSpec());

    if (instance != null) {
      this.withExportTo(instance.getExportTo());
      this.withGateways(instance.getGateways());
      this.withHosts(instance.getHosts());
      this.withHttp(instance.getHttp());
      this.withTcp(instance.getTcp());
      this.withTls(instance.getTls());
      this.withExportTo(instance.getExportTo());
      this.withGateways(instance.getGateways());
      this.withHosts(instance.getHosts());
      this.withHttp(instance.getHttp());
      this.withTcp(instance.getTcp());
      this.withTls(instance.getTls());
    }
    this.validationEnabled = validationEnabled; 
  }
  VirtualServiceSpecFluent<?> fluent;
  Boolean validationEnabled;
  public VirtualServiceSpec build() {
    VirtualServiceSpec buildable = new VirtualServiceSpec(fluent.getExportTo(),fluent.getGateways(),fluent.getHosts(),fluent.buildHttp(),fluent.buildTcp(),fluent.buildTls());
    return buildable;
  }
  
}